/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.khoryl.elements.entity.zombie;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.util.Timespan;
import ch.njol.skript.util.Version;
import ch.njol.util.coll.CollectionUtils;
import me.limeglass.khoryl.lang.EntityPropertyExpression;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Zombie;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Zombie Drowned Conversion Time")
@Description(value={"Gets the amount of ticks until this entity will be converted to a Drowned as a result of being underwater."})
@Since(value="1.0.0")
public class ExprDrownedConversionTime
extends EntityPropertyExpression<LivingEntity, Zombie, Timespan> {
    protected String getPropertyName() {
        return "drowned conversion time";
    }

    @Override
    @Nullable
    protected Timespan grab(Zombie villager) {
        if (!villager.isConverting()) {
            return null;
        }
        return Timespan.fromTicks_i((long)villager.getConversionTime());
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.DELETE) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Timespan.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (delta[0] == null) {
            return;
        }
        int ticks = (int)((Timespan)delta[0]).getTicks_i();
        switch (mode) {
            case ADD: {
                for (Zombie zombie : this.getEntities(event)) {
                    if (!zombie.isConverting()) {
                        zombie.setConversionTime(ticks);
                        continue;
                    }
                    int existing = zombie.getConversionTime();
                    zombie.setConversionTime(existing + ticks);
                }
                break;
            }
            case REMOVE: {
                for (Zombie zombie : this.getEntities(event)) {
                    if (!zombie.isConverting()) continue;
                    int existing = zombie.getConversionTime();
                    zombie.setConversionTime(existing - ticks);
                }
                break;
            }
            case SET: {
                for (Zombie zombie : this.getEntities(event)) {
                    zombie.setConversionTime(ticks);
                }
                break;
            }
            case DELETE: {
                for (Zombie zombie : this.getEntities(event)) {
                    zombie.setConversionTime(0);
                }
                break;
            }
        }
    }

    static {
        if (!Skript.getMinecraftVersion().isSmallerThan(new Version(new int[]{1, 13}))) {
            ExprDrownedConversionTime.register(ExprDrownedConversionTime.class, Timespan.class, (String)"drown[ed] (conversion|converting) time", (String)"livingentities");
        }
    }
}

