/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.khoryl.elements.entity.wolf;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.util.Color;
import ch.njol.skript.util.SkriptColor;
import ch.njol.util.coll.CollectionUtils;
import me.limeglass.khoryl.lang.EntityPropertyExpression;
import org.bukkit.DyeColor;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Wolf;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Wolf Collar Color")
@Description(value={"Get the collar color of wolfs."})
@Since(value="1.0.0")
public class ExprCollarColor
extends EntityPropertyExpression<LivingEntity, Wolf, Color> {
    protected String getPropertyName() {
        return "collar colour";
    }

    @Override
    @Nullable
    protected Color grab(Wolf wolf) {
        return (Color)SkriptColor.fromDyeColor((DyeColor)wolf.getCollarColor()).orElse(SkriptColor.DARK_RED);
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.DELETE) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Color.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (delta[0] == null) {
            return;
        }
        Color color = (Color)delta[0];
        switch (mode) {
            case DELETE: 
            case RESET: {
                for (Wolf wolf : this.getEntities(event)) {
                    wolf.setCollarColor(DyeColor.RED);
                }
                break;
            }
            case SET: {
                for (Wolf wolf : this.getEntities(event)) {
                    wolf.setCollarColor(color.asDyeColor());
                }
                break;
            }
        }
    }

    static {
        ExprCollarColor.register(ExprCollarColor.class, Color.class, (String)"collar colo[u]r", (String)"livingentities");
    }
}

