/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.khoryl.elements.entity.villager;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.util.Version;
import ch.njol.util.coll.CollectionUtils;
import me.limeglass.khoryl.lang.EntityPropertyExpression;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Villager;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Villager Experience")
@Description(value={"Gets the trading experience of villagers."})
@Since(value="1.0.0")
public class ExprVillagerExperience
extends EntityPropertyExpression<LivingEntity, Villager, Number> {
    protected String getPropertyName() {
        return "villager experience";
    }

    @Override
    @Nullable
    protected Number grab(Villager villager) {
        return villager.getVillagerExperience();
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode != Changer.ChangeMode.REMOVE_ALL) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (delta[0] == null) {
            return;
        }
        int experience = ((Number)delta[0]).intValue();
        switch (mode) {
            case ADD: {
                for (Villager villager : this.getEntities(event)) {
                    int existing = villager.getVillagerExperience();
                    villager.setVillagerExperience(existing + experience);
                }
                break;
            }
            case REMOVE: {
                for (Villager villager : this.getEntities(event)) {
                    int existing = villager.getVillagerExperience();
                    villager.setVillagerExperience(existing - experience);
                }
                break;
            }
            case SET: {
                for (Villager villager : this.getEntities(event)) {
                    villager.setVillagerExperience(experience);
                }
                break;
            }
            case DELETE: 
            case RESET: {
                for (Villager villager : this.getEntities(event)) {
                    villager.setVillagerExperience(0);
                }
                break;
            }
        }
    }

    static {
        if (!Skript.getMinecraftVersion().isSmallerThan(new Version(new int[]{1, 14}))) {
            ExprVillagerExperience.register(ExprVillagerExperience.class, Number.class, (String)"villager [trading] experience", (String)"livingentities");
        }
    }
}

