/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.khoryl.elements.entity.villager;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Version;
import ch.njol.util.Kleenean;
import me.limeglass.khoryl.lang.EntitySyntax;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Villager;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Villager Wakeup")
@Description(value={"Causes villagers to wake up if they're currently sleeping."})
@Since(value="1.0.0")
public class EffVillagerWakeup
extends Effect
implements EntitySyntax<Villager> {
    private Expression<LivingEntity> villagers;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.villagers = exprs[0];
        return true;
    }

    protected void execute(Event event) {
        for (LivingEntity entity : (LivingEntity[])this.villagers.getArray(event)) {
            if (!this.accepts((Entity)entity)) {
                return;
            }
            ((Villager)entity).wakeup();
        }
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "wake up villagers " + this.villagers.toString(event, debug);
    }

    static {
        if (!Skript.getMinecraftVersion().isSmallerThan(new Version(new int[]{1, 14, 4}))) {
            Skript.registerEffect(EffVillagerWakeup.class, (String[])new String[]{"wake[ ]up villager[s] %livingentities%"});
        }
    }
}

