/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.khoryl.elements.entity.villager;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Version;
import ch.njol.util.Kleenean;
import me.limeglass.khoryl.lang.EntitySyntax;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Villager;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Villager Sleep")
@Description(value={"Attempts to make villagers sleep at a given location."})
@Since(value="1.0.0")
public class EffVillagerSleep
extends Effect
implements EntitySyntax<Villager> {
    private Expression<LivingEntity> villager;
    private Expression<Location> location;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.villager = exprs[0];
        this.location = exprs[1];
        return true;
    }

    protected void execute(Event event) {
        LivingEntity entity = (LivingEntity)this.villager.getSingle(event);
        if (!this.accepts((Entity)entity)) {
            return;
        }
        ((Villager)entity).sleep((Location)this.location.getSingle(event));
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "forcing villager " + this.villager.toString(event, debug) + " to sleep at " + this.location.toString(event, debug);
    }

    static {
        if (!Skript.getMinecraftVersion().isSmallerThan(new Version(new int[]{1, 14, 4}))) {
            Skript.registerEffect(EffVillagerSleep.class, (String[])new String[]{"(force|make) villager %livingentity% sleep at %location%"});
        }
    }
}

