/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.khoryl.elements.entity.vex;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.util.Version;
import ch.njol.util.coll.CollectionUtils;
import me.limeglass.khoryl.lang.EntityPropertyExpression;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Vex;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Vex Charging")
@Description(value={"Gets the charging state of vexes."})
@Since(value="1.0.0")
public class ExprCharging
extends EntityPropertyExpression<LivingEntity, Vex, Boolean> {
    protected String getPropertyName() {
        return "vex charging";
    }

    @Override
    @Nullable
    protected Boolean grab(Vex vex) {
        return vex.isCharging();
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Boolean.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (delta[0] == null) {
            return;
        }
        boolean charging = (Boolean)delta[0];
        for (Vex vex : this.getEntities(event)) {
            vex.setCharging(charging);
        }
    }

    static {
        if (!Skript.getMinecraftVersion().isSmallerThan(new Version(new int[]{1, 13}))) {
            ExprCharging.register(ExprCharging.class, Boolean.class, (String)"vex charg(ing|e)", (String)"livingentities");
        }
    }
}

