/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.khoryl.elements.entity.tropicalfish;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.util.SkriptColor;
import ch.njol.skript.util.Version;
import ch.njol.util.coll.CollectionUtils;
import me.limeglass.khoryl.lang.EntityPropertyExpression;
import org.bukkit.DyeColor;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.TropicalFish;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Tropical Fish Body Colour")
@Description(value={"Grab the body colour of tropical fishes."})
@Since(value="1.0.0")
public class ExprBodyColour
extends EntityPropertyExpression<LivingEntity, TropicalFish, SkriptColor> {
    protected String getPropertyName() {
        return "fish body colour";
    }

    @Override
    @Nullable
    protected SkriptColor grab(TropicalFish fish) {
        return SkriptColor.fromDyeColor((DyeColor)fish.getBodyColor()).orElse(SkriptColor.BLACK);
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{SkriptColor.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (delta[0] == null) {
            return;
        }
        SkriptColor color = (SkriptColor)delta[0];
        for (TropicalFish fish : this.getEntities(event)) {
            fish.setBodyColor(color.asDyeColor());
        }
    }

    static {
        if (!Skript.getMinecraftVersion().isSmallerThan(new Version(new int[]{1, 13}))) {
            ExprBodyColour.register(ExprBodyColour.class, SkriptColor.class, (String)"[tropical] fish [body] colo[u]r", (String)"livingentities");
        }
    }
}

