/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.khoryl.elements.entity.merchant.recipe;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.util.Version;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.event.Event;
import org.bukkit.inventory.MerchantRecipe;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Merchant Recipe Experience Reward")
@Description(value={"Whether to reward experience to the player within a trade of this merchant recipe."})
@Since(value="1.0.0")
public class ExprRecipeReward
extends SimplePropertyExpression<MerchantRecipe, Boolean> {
    public Class<? extends Boolean> getReturnType() {
        return Boolean.class;
    }

    protected String getPropertyName() {
        return "experience reward";
    }

    @Nullable
    public Boolean convert(MerchantRecipe recipe) {
        return recipe.hasExperienceReward();
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Boolean.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (delta[0] == null) {
            return;
        }
        boolean flag = (Boolean)delta[0];
        for (MerchantRecipe recipe : (MerchantRecipe[])this.getExpr().getArray(event)) {
            recipe.setExperienceReward(flag);
        }
    }

    static {
        if (!Skript.getMinecraftVersion().isSmallerThan(new Version(new int[]{1, 14}))) {
            ExprRecipeReward.register(ExprRecipeReward.class, Boolean.class, (String)"[player] experience reward", (String)"merchantrecipes");
        }
    }
}

