/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.khoryl.elements.entity.merchant.recipe;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.util.Version;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.event.Event;
import org.bukkit.inventory.MerchantRecipe;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Merchant Recipe Experience")
@Description(value={"Gets the amount of experience the villager earns from the merchant recipe in trades."})
@Since(value="1.0.0")
public class ExprRecipeExperience
extends SimplePropertyExpression<MerchantRecipe, Number> {
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    protected String getPropertyName() {
        return "villager experience";
    }

    @Nullable
    public Number convert(MerchantRecipe recipe) {
        return recipe.getVillagerExperience();
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (delta[0] == null) {
            return;
        }
        int experience = ((Number)delta[0]).intValue();
        switch (mode) {
            case ADD: {
                for (MerchantRecipe recipe : (MerchantRecipe[])this.getExpr().getArray(event)) {
                    int existing = recipe.getVillagerExperience();
                    recipe.setVillagerExperience(existing + experience);
                }
                break;
            }
            case REMOVE: {
                for (MerchantRecipe recipe : (MerchantRecipe[])this.getExpr().getArray(event)) {
                    int existing = recipe.getVillagerExperience();
                    recipe.setVillagerExperience(existing - experience);
                }
                break;
            }
            case SET: {
                for (MerchantRecipe recipe : (MerchantRecipe[])this.getExpr().getArray(event)) {
                    recipe.setVillagerExperience(experience);
                }
                break;
            }
        }
    }

    static {
        if (!Skript.getMinecraftVersion().isSmallerThan(new Version(new int[]{1, 14}))) {
            ExprRecipeExperience.register(ExprRecipeExperience.class, Number.class, (String)"villager experience", (String)"merchantrecipes");
        }
    }
}

