/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.khoryl.elements.entity.merchant.recipe;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.Version;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.bukkit.event.Event;
import org.bukkit.inventory.MerchantRecipe;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Merchant Recipe")
@Description(value={"Create a new merchant recipe for villagers."})
@Examples(value={"set {_recipe} to a new merchant recipe with result paper with lore \"&6Elder Scroll\" and 5 max uses from ingredients diamond and 5 sugar cane"})
@Since(value="1.0.0")
public class ExprMerchantRecipe
extends SimpleExpression<MerchantRecipe> {
    private Expression<ItemType> itemType;
    private Expression<ItemType> ingredients;
    private Expression<Number> uses;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends MerchantRecipe> getReturnType() {
        return MerchantRecipe.class;
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.itemType = exprs[0];
        this.uses = exprs[1];
        if (matchedPattern == 1) {
            this.ingredients = exprs[2];
        }
        return true;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "merchant recipe " + this.itemType.toString(event, debug) + " with max uses " + this.uses.toString(event, debug);
    }

    @Nullable
    protected MerchantRecipe[] get(Event event) {
        ItemType item = (ItemType)this.itemType.getSingle(event);
        Number max = (Number)this.uses.getSingle(event);
        if (this.itemType == null || max == null) {
            return null;
        }
        MerchantRecipe recipe = new MerchantRecipe(item.getRandom(), max.intValue());
        if (this.ingredients != null) {
            recipe.setIngredients(Arrays.stream(this.ingredients.getArray(event)).map(it -> it.getRandom()).collect(Collectors.toList()));
        }
        return (MerchantRecipe[])CollectionUtils.array((Object[])new MerchantRecipe[]{recipe});
    }

    static {
        if (!Skript.getMinecraftVersion().isSmallerThan(new Version(new int[]{1, 14}))) {
            Skript.registerExpression(ExprMerchantRecipe.class, MerchantRecipe.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[new] merchant recipe with result %itemtype% and %number% max uses", "[new] merchant recipe with result %itemtype%[,] [and] with %number% max uses (and|from) ingredients %itemtypes%"});
        }
    }
}

