/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.khoryl.elements.entity.merchant;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.Arrays;
import me.limeglass.khoryl.lang.EntitySyntax;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.MerchantRecipe;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Merchant Recipes")
@Description(value={"Gets the villagers recipes."})
@Since(value="1.0.0")
public class ExprMerchantRecipes
extends SimpleExpression<MerchantRecipe>
implements EntitySyntax<AbstractVillager> {
    private Expression<LivingEntity> villagers;

    public boolean isSingle() {
        return false;
    }

    public Class<? extends MerchantRecipe> getReturnType() {
        return MerchantRecipe.class;
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.villagers = exprs[0];
        return true;
    }

    @Nullable
    protected MerchantRecipe[] get(Event event) {
        return (MerchantRecipe[])Arrays.stream(this.villagers.getArray(event)).filter(entity -> entity != null).filter(entity -> this.accepts((Entity)entity)).map(villager -> ((Merchant)villager).getRecipes()).flatMap(recipies -> recipies.stream()).toArray(MerchantRecipe[]::new);
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "recipes of " + this.villagers.toString(event, debug);
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return (Class[])CollectionUtils.array((Object[])new Class[]{MerchantRecipe.class, MerchantRecipe[].class});
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (delta == null || delta[0] == null) {
            return;
        }
        switch (mode) {
            case SET: {
                for (AbstractVillager villager : this.getEntities(this.villagers, event)) {
                    villager.getRecipes().clear();
                }
            }
            case ADD: {
                for (MerchantRecipe recipe : (MerchantRecipe[])delta) {
                    for (AbstractVillager villager : this.getEntities(this.villagers, event)) {
                        villager.getRecipes().add(recipe);
                    }
                }
                break;
            }
            case RESET: 
            case DELETE: {
                for (AbstractVillager villager : this.getEntities(this.villagers, event)) {
                    villager.getRecipes().clear();
                }
                break;
            }
            case REMOVE_ALL: 
            case REMOVE: {
                for (MerchantRecipe recipe : (MerchantRecipe[])delta) {
                    for (AbstractVillager villager : this.getEntities(this.villagers, event)) {
                        villager.getRecipes().remove(recipe);
                    }
                }
                break;
            }
        }
    }

    static {
        Skript.registerExpression(ExprMerchantRecipes.class, MerchantRecipe.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[(all [[of] the]|the)] [merchant] recipes (from|of) %livingentities%", "[(all [[of] the]|the)] %livingentities%'[s] [merchant] recipes"});
    }
}

