/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.khoryl.elements.entity.merchant;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.util.List;
import me.limeglass.khoryl.lang.EntitySyntax;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.inventory.MerchantRecipe;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Merchant Recipes")
@Description(value={"Set/removes the spot the recipe should be at."})
@Since(value="1.0.0")
public class EffMerchantRecipe
extends Effect
implements EntitySyntax<AbstractVillager> {
    private Expression<MerchantRecipe> recipe;
    private Expression<LivingEntity> villager;
    private Expression<Number> index;
    private boolean set;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.set = parseResult.mark == 1;
        this.index = exprs[0];
        this.recipe = exprs[1];
        this.villager = exprs[2];
        return true;
    }

    protected void execute(Event event) {
        LivingEntity entity = (LivingEntity)this.villager.getSingle(event);
        if (!this.accepts((Entity)entity)) {
            return;
        }
        AbstractVillager villagerEntity = (AbstractVillager)entity;
        Number number = (Number)this.index.getSingle(event);
        if (number == null) {
            return;
        }
        if (this.set) {
            MerchantRecipe merchantRecipe = (MerchantRecipe)this.recipe.getSingle(event);
            if (merchantRecipe == null) {
                return;
            }
            villagerEntity.setRecipe(number.intValue(), merchantRecipe);
            return;
        }
        List recipes = villagerEntity.getRecipes();
        if (recipes.size() >= number.intValue() || number.intValue() < 0) {
            return;
        }
        recipes.remove(number.intValue());
    }

    public String toString(@Nullable Event event, boolean debug) {
        return this.set ? "setting " : "removing of recipe at " + this.index.toString(event, debug) + " for villager " + this.villager.toString(event, debug);
    }

    static {
        Skript.registerEffect(EffMerchantRecipe.class, (String[])new String[]{"(1\u00a6set|2\u00a6remove) [merchant] recipe at [index] %number% [to %merchantrecipe%] (for|of) [villager] %livingentity%"});
    }
}

