/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.khoryl.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.util.Version;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="AI")
@Description(value={"Returns whether an entity has AI."})
@Examples(value={"set artificial intelligence of target entity to false"})
@Since(value="1.0.0")
public class ExprAI
extends SimplePropertyExpression<LivingEntity, Boolean> {
    public Class<? extends Boolean> getReturnType() {
        return Boolean.class;
    }

    protected String getPropertyName() {
        return "artificial intelligence";
    }

    @Nullable
    public Boolean convert(LivingEntity entity) {
        return entity.hasAI();
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Boolean.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (delta[0] == null) {
            return;
        }
        boolean value = (Boolean)delta[0];
        for (LivingEntity entity : (LivingEntity[])this.getExpr().getArray(event)) {
            entity.setAI(value);
        }
    }

    static {
        if (!Skript.getMinecraftVersion().isSmallerThan(new Version(new int[]{1, 11}))) {
            ExprAI.register(ExprAI.class, Boolean.class, (String)"(ai|artificial intelligence)", (String)"livingentities");
        }
    }
}

