/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.khoryl.elements.entity.zombie.villager;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.util.Timespan;
import ch.njol.util.coll.CollectionUtils;
import me.limeglass.khoryl.lang.EntityPropertyExpression;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Zombie Villager Conversion Time")
@Description(value={"Gets the amount of ticks until this entity will be converted to a Villager as a result of being cured."})
@Since(value="1.0.0")
public class ExprVillagerConversionTime
extends EntityPropertyExpression<LivingEntity, ZombieVillager, Timespan> {
    protected String getPropertyName() {
        return "villager conversion time";
    }

    @Override
    @Nullable
    protected Timespan grab(ZombieVillager villager) {
        if (!villager.isConverting()) {
            return null;
        }
        return Timespan.fromTicks_i((long)villager.getConversionTime());
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.DELETE) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Timespan.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (delta[0] == null) {
            return;
        }
        int ticks = (int)((Timespan)delta[0]).getTicks_i();
        switch (mode) {
            case ADD: {
                for (ZombieVillager villager : this.getEntities(event)) {
                    if (!villager.isConverting()) {
                        villager.setConversionTime(ticks);
                        continue;
                    }
                    int existing = villager.getConversionTime();
                    villager.setConversionTime(existing + ticks);
                }
                break;
            }
            case REMOVE: {
                for (ZombieVillager villager : this.getEntities(event)) {
                    if (!villager.isConverting()) continue;
                    int existing = villager.getConversionTime();
                    villager.setConversionTime(existing - ticks);
                }
                break;
            }
            case SET: {
                for (ZombieVillager villager : this.getEntities(event)) {
                    villager.setConversionTime(ticks);
                }
                break;
            }
            case DELETE: {
                for (ZombieVillager villager : this.getEntities(event)) {
                    villager.setConversionTime(0);
                }
                break;
            }
        }
    }

    static {
        ExprVillagerConversionTime.register(ExprVillagerConversionTime.class, Timespan.class, (String)"[[zombie] villager] (conversion|converting) time", (String)"livingentities");
    }
}

