/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.khoryl.elements.entity.merchant.recipe;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.util.Version;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.event.Event;
import org.bukkit.inventory.MerchantRecipe;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Merchant Recipe Multiplier")
@Description(value={"Gets the additive price multiplier for the cost of the recipe."})
@Since(value="1.0.0")
public class ExprRecipeMultiplier
extends SimplePropertyExpression<MerchantRecipe, Number> {
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    protected String getPropertyName() {
        return "price multiplier";
    }

    @Nullable
    public Number convert(MerchantRecipe recipe) {
        return Float.valueOf(recipe.getPriceMultiplier());
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (delta[0] == null) {
            return;
        }
        int cost = ((Number)delta[0]).intValue();
        switch (mode) {
            case ADD: {
                for (MerchantRecipe recipe : (MerchantRecipe[])this.getExpr().getArray(event)) {
                    float existing = recipe.getPriceMultiplier();
                    recipe.setPriceMultiplier(existing + (float)cost);
                }
                break;
            }
            case REMOVE: {
                for (MerchantRecipe recipe : (MerchantRecipe[])this.getExpr().getArray(event)) {
                    float existing = recipe.getPriceMultiplier();
                    recipe.setPriceMultiplier(existing - (float)cost);
                }
                break;
            }
            case SET: {
                for (MerchantRecipe recipe : (MerchantRecipe[])this.getExpr().getArray(event)) {
                    recipe.setPriceMultiplier((float)cost);
                }
                break;
            }
        }
    }

    static {
        if (!Skript.getMinecraftVersion().isSmallerThan(new Version(new int[]{1, 14}))) {
            ExprRecipeMultiplier.register(ExprRecipeMultiplier.class, Number.class, (String)"price multiplier", (String)"merchantrecipes");
        }
    }
}

