/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.khoryl.elements.entity.merchant.recipe;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.util.Version;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.event.Event;
import org.bukkit.inventory.MerchantRecipe;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Merchant Recipe Max Uses")
@Description(value={"Get the maximum number of uses this trade has."})
@Since(value="1.0.0")
public class ExprRecipeMaxUses
extends SimplePropertyExpression<MerchantRecipe, Number> {
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    protected String getPropertyName() {
        return "max uses";
    }

    @Nullable
    public Number convert(MerchantRecipe recipe) {
        return recipe.getMaxUses();
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (delta[0] == null) {
            return;
        }
        int uses = ((Number)delta[0]).intValue();
        switch (mode) {
            case ADD: {
                for (MerchantRecipe recipe : (MerchantRecipe[])this.getExpr().getArray(event)) {
                    int existing = recipe.getMaxUses();
                    recipe.setMaxUses(existing + uses);
                }
                break;
            }
            case REMOVE: {
                for (MerchantRecipe recipe : (MerchantRecipe[])this.getExpr().getArray(event)) {
                    int existing = recipe.getMaxUses();
                    recipe.setMaxUses(existing - uses);
                }
                break;
            }
            case SET: {
                for (MerchantRecipe recipe : (MerchantRecipe[])this.getExpr().getArray(event)) {
                    recipe.setMaxUses(uses);
                }
                break;
            }
        }
    }

    static {
        if (!Skript.getMinecraftVersion().isSmallerThan(new Version(new int[]{1, 14}))) {
            ExprRecipeMaxUses.register(ExprRecipeMaxUses.class, Number.class, (String)"max uses", (String)"merchantrecipes");
        }
    }
}

