/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.khoryl.elements.entity.merchant.recipe;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.Arrays;
import org.bukkit.event.Event;
import org.bukkit.inventory.MerchantRecipe;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Merchant Recipe Ingredients")
@Since(value="1.0.0")
public class ExprRecipeIngredients
extends SimpleExpression<ItemType> {
    private Expression<MerchantRecipe> recipes;

    public boolean isSingle() {
        return false;
    }

    public Class<? extends ItemType> getReturnType() {
        return ItemType.class;
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.recipes = exprs[0];
        return true;
    }

    @Nullable
    protected ItemType[] get(Event event) {
        return (ItemType[])Arrays.stream(this.recipes.getArray(event)).filter(recipe -> recipe != null).map(recipe -> recipe.getIngredients()).flatMap(ingredients -> ingredients.stream()).map(itemstack -> new ItemType(itemstack)).toArray(ItemType[]::new);
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "ingredients of " + this.recipes.toString(event, debug);
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return (Class[])CollectionUtils.array((Object[])new Class[]{ItemType.class, ItemType[].class});
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (delta == null || delta[0] == null) {
            return;
        }
        switch (mode) {
            case SET: {
                for (ItemType itemType : (MerchantRecipe[])this.recipes.getArray(event)) {
                    itemType.getIngredients().clear();
                }
            }
            case ADD: {
                for (ItemType itemType : (ItemType[])delta) {
                    for (MerchantRecipe recipe : (MerchantRecipe[])this.recipes.getArray(event)) {
                        recipe.addIngredient(itemType.getRandom());
                    }
                }
                break;
            }
            case RESET: 
            case DELETE: {
                for (MerchantRecipe merchantRecipe : (MerchantRecipe[])this.recipes.getArray(event)) {
                    merchantRecipe.getIngredients().clear();
                }
                break;
            }
            case REMOVE_ALL: 
            case REMOVE: {
                for (ItemType itemType : (ItemType[])delta) {
                    for (MerchantRecipe recipe : (MerchantRecipe[])this.recipes.getArray(event)) {
                        recipe.getIngredients().removeIf(item -> item.isSimilar(ingredient.getRandom()));
                    }
                }
                break;
            }
        }
    }

    static {
        Skript.registerExpression(ExprRecipeIngredients.class, ItemType.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[(all [[of] the]|the)] [merchant] ingredients (from|of) %merchantrecipes%", "[(all [[of] the]|the)] %merchantrecipes%'[s] [merchant] ingredients"});
    }
}

