/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.khoryl.elements;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.classes.Serializer;
import ch.njol.skript.expressions.base.EventValueExpression;
import ch.njol.skript.lang.DefaultExpression;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Version;
import ch.njol.yggdrasil.Fields;
import com.google.common.collect.Streams;
import java.io.NotSerializableException;
import java.io.StreamCorruptedException;
import java.util.Iterator;
import java.util.stream.Collectors;
import me.limeglass.khoryl.lang.EnumClassInfo;
import org.bukkit.entity.Villager;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantRecipe;
import org.eclipse.jdt.annotation.Nullable;

public class Types {
    static {
        EnumClassInfo.create(Villager.Profession.class, "villagerprofession").register();
        if (!Skript.getMinecraftVersion().isSmallerThan(new Version(new int[]{1, 13}))) {
            EnumClassInfo.create(Villager.Type.class, "villagertype").register();
        }
        Classes.registerClass((ClassInfo)new ClassInfo(MerchantRecipe.class, "merchantrecipe").user(new String[]{"merchant ?recip(e|ies)"}).name("Merchant Recipe").description(new String[]{"A configuration of effects that defines the firework when exploded."}).defaultExpression((DefaultExpression)new EventValueExpression(MerchantRecipe.class)).parser((Parser)new Parser<MerchantRecipe>(){

            @Nullable
            public MerchantRecipe parse(String input, ParseContext context) {
                return null;
            }

            public boolean canParse(ParseContext context) {
                return false;
            }

            public String toString(MerchantRecipe recipe, int flags) {
                return "Merchant recipe " + recipe.toString();
            }

            public String toVariableNameString(MerchantRecipe recipe) {
                return "Merchant recipe " + ItemType.toString((ItemStack)recipe.getResult());
            }

            public String getVariableNamePattern() {
                return "\\S+";
            }
        }).serializer((Serializer)new Serializer<MerchantRecipe>(){

            public Fields serialize(MerchantRecipe recipe) throws NotSerializableException {
                Fields fields = new Fields();
                fields.putPrimitive("experience", (Object)recipe.getVillagerExperience());
                fields.putPrimitive("multiplier", (Object)Float.valueOf(recipe.getPriceMultiplier()));
                fields.putPrimitive("reward", (Object)recipe.hasExperienceReward());
                fields.putPrimitive("max-uses", (Object)recipe.getMaxUses());
                fields.putPrimitive("uses", (Object)recipe.getUses());
                fields.putObject("result", (Object)recipe.getResult());
                Fields ingredients = new Fields();
                int spot = 0;
                for (ItemStack ingredient : recipe.getIngredients()) {
                    ingredients.putObject(spot + "", (Object)ingredient);
                    ++spot;
                }
                ingredients.putObject("ingredients", (Object)ingredients);
                return fields;
            }

            public void deserialize(MerchantRecipe recipe, Fields fields) {
                assert (false);
            }

            public MerchantRecipe deserialize(Fields fields) throws StreamCorruptedException {
                ItemStack result = (ItemStack)fields.getAndRemoveObject("result", ItemStack.class);
                int max = (Integer)fields.getAndRemovePrimitive("max-uses", Integer.TYPE);
                MerchantRecipe recipe = new MerchantRecipe(result, max);
                recipe.setVillagerExperience(((Integer)fields.getAndRemovePrimitive("experience", Integer.TYPE)).intValue());
                recipe.setPriceMultiplier(((Float)fields.getAndRemovePrimitive("multiplier", Float.TYPE)).floatValue());
                recipe.setExperienceReward(((Boolean)fields.getAndRemovePrimitive("reward", Boolean.TYPE)).booleanValue());
                recipe.setUses(((Integer)fields.getAndRemovePrimitive("uses", Integer.TYPE)).intValue());
                Fields ingredients = (Fields)fields.getAndRemoveObject("ingredients", Fields.class);
                recipe.setIngredients(Streams.stream((Iterator)ingredients.iterator()).map(context -> {
                    try {
                        return (ItemStack)context.getObject(ItemStack.class);
                    }
                    catch (StreamCorruptedException e) {
                        e.printStackTrace();
                        return null;
                    }
                }).filter(value -> value != null).collect(Collectors.toList()));
                return recipe;
            }

            public boolean mustSyncDeserialization() {
                return false;
            }

            protected boolean canBeInstantiated() {
                return false;
            }
        }));
    }
}

