/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.yggdrasil;

import ch.njol.yggdrasil.Fields;
import ch.njol.yggdrasil.YggdrasilSerializer;
import java.io.NotSerializableException;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.eclipse.jdt.annotation.Nullable;

public class JRESerializer
extends YggdrasilSerializer<Object> {
    private static final Class<?>[] supportedClasses = new Class[]{ArrayList.class, LinkedList.class, HashSet.class, HashMap.class, UUID.class};
    private static final Set<Class<?>> set = new HashSet(Arrays.asList(supportedClasses));

    @Override
    @Nullable
    public Class<?> getClass(String id) {
        Class<?>[] classArray = supportedClasses;
        int n = supportedClasses.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> c = classArray[n2];
            if (c.getSimpleName().equals(id)) {
                return c;
            }
            ++n2;
        }
        return null;
    }

    @Override
    @Nullable
    public String getID(Class<?> c) {
        if (set.contains(c)) {
            return c.getSimpleName();
        }
        return null;
    }

    @Override
    public Fields serialize(Object o) {
        if (!set.contains(o.getClass())) {
            throw new IllegalArgumentException();
        }
        Fields f = new Fields();
        if (o instanceof Collection) {
            Collection c = (Collection)o;
            f.putObject("values", c.toArray());
        } else if (o instanceof Map) {
            Map m = (Map)o;
            f.putObject("keys", m.keySet().toArray());
            f.putObject("values", m.values().toArray());
        } else if (o instanceof UUID) {
            f.putPrimitive("mostSigBits", ((UUID)o).getMostSignificantBits());
            f.putPrimitive("leastSigBits", ((UUID)o).getLeastSignificantBits());
        }
        assert (f.size() > 0) : o;
        return f;
    }

    @Override
    public boolean canBeInstantiated(Class<? extends Object> c) {
        return c != UUID.class;
    }

    @Override
    @Nullable
    public <T> T newInstance(Class<T> c) {
        try {
            return c.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            assert (false);
            return null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            assert (false);
            return null;
        }
    }

    @Override
    public void deserialize(Object o, Fields fields) throws StreamCorruptedException {
        try {
            if (o instanceof Collection) {
                Collection c = (Collection)o;
                Object[] values2 = fields.getObject("values", Object[].class);
                if (values2 == null) {
                    throw new StreamCorruptedException();
                }
                c.addAll(Arrays.asList(values2));
                return;
            }
            if (o instanceof Map) {
                Map m = (Map)o;
                Object[] keys2 = fields.getObject("keys", Object[].class);
                Object[] values3 = fields.getObject("values", Object[].class);
                if (keys2 == null || values3 == null || keys2.length != values3.length) {
                    throw new StreamCorruptedException();
                }
                int i = 0;
                while (i < keys2.length) {
                    m.put(keys2[i], values3[i]);
                    ++i;
                }
                return;
            }
        }
        catch (Exception e) {
            throw new StreamCorruptedException(String.valueOf(e.getClass().getSimpleName()) + ": " + e.getMessage());
        }
        throw new StreamCorruptedException();
    }

    @Override
    public <E> E deserialize(Class<E> c, Fields fields) throws StreamCorruptedException, NotSerializableException {
        if (c == UUID.class) {
            return (E)new UUID(fields.getPrimitive("mostSigBits", Long.TYPE), fields.getPrimitive("leastSigBits", Long.TYPE));
        }
        throw new StreamCorruptedException();
    }
}

