/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.ExprSortedList;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Shuffled List")
@Description(value={"Shuffles given list randomly. This is done by replacing indices by random numbers in resulting list."})
@Examples(value={"set {_list::*} to  shuffled {_list::*"})
@Since(value="2.2-dev32")
public class ExprShuffledList
extends SimpleExpression<Object> {
    private Expression<Object> list;

    static {
        Skript.registerExpression(ExprSortedList.class, Object.class, ExpressionType.COMBINED, "shuffled %objects%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.list = exprs[0];
        return true;
    }

    @Override
    @Nullable
    protected Object[] get(Event e) {
        Object[] origin = this.list.getAll(e);
        List<Object> shuffled = Arrays.asList((Object[])origin.clone());
        try {
            Collections.shuffle(shuffled);
        }
        catch (IllegalArgumentException ex) {
            Skript.error("Tried to sort a list, but some objects are not comparable!");
        }
        return shuffled.toArray();
    }

    @Override
    public Class<? extends Object> getReturnType() {
        return Object.class;
    }

    @Override
    public boolean isSingle() {
        return false;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "shuffled list";
    }
}

