/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.Math2;
import ch.njol.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Lore")
@Description(value={"An item's lore."})
@Examples(value={"set the 1st line of the item's lore to \"<orange>Excalibur 2.0\""})
@Since(value="2.1")
public class ExprLore
extends SimpleExpression<String> {
    @Nullable
    private Expression<Number> line;
    private Expression<?> item;

    static {
        try {
            ItemMeta.class.getName();
            Skript.registerExpression(ExprLore.class, String.class, ExpressionType.PROPERTY, "[the] lore of %itemstack/itemtype%", "%itemstack/itemtype%'[s] lore", "[the] line %number% of [the] lore of %itemstack/itemtype%", "[the] line %number% of %itemstack/itemtype%'[s] lore", "[the] %number%(st|nd|rd|th) line of [the] lore of %itemstack/itemtype%", "[the] %number%(st|nd|rd|th) line of %itemstack/itemtype%'[s] lore");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.line = exprs.length > 1 ? exprs[0] : null;
        this.item = exprs[exprs.length - 1];
        return true;
    }

    @Override
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @Nullable
    protected String[] get(Event e) {
        ItemMeta meta;
        Number n;
        Object i = this.item.getSingle(e);
        Number number = n = this.line != null ? (Number)this.line.getSingle(e) : (Number)null;
        if (n == null && this.line != null) {
            return null;
        }
        if (i == null || i instanceof ItemStack && ((ItemStack)i).getType() == Material.AIR) {
            return new String[0];
        }
        ItemMeta itemMeta = meta = i instanceof ItemStack ? ((ItemStack)i).getItemMeta() : (ItemMeta)((ItemType)i).getItemMeta();
        if (meta == null || !meta.hasLore()) {
            return new String[0];
        }
        if (n == null) {
            return new String[0];
        }
        int l = n.intValue() - 1;
        List lore = meta.getLore();
        if (l < 0 || l >= lore.size()) {
            return new String[0];
        }
        return new String[]{(String)lore.get(l)};
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return String.valueOf(this.line != null ? "the line " + this.line.toString(e, debug) + " of " : "") + "the lore of " + this.item.toString(e, debug);
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        switch (mode) {
            case ADD: 
            case SET: 
            case REMOVE: 
            case REMOVE_ALL: 
            case DELETE: {
                if (Changer.ChangerUtils.acceptsChange(this.item, Changer.ChangeMode.SET, ItemStack.class, ItemType.class)) {
                    return new Class[]{String.class};
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) throws UnsupportedOperationException {
        List<Object> lore;
        ItemMeta meta;
        Object i;
        block37: {
            Number n;
            block36: {
                i = this.item.getSingle(e);
                if (i == null || i instanceof ItemStack && ((ItemStack)i).getType() == Material.AIR) {
                    return;
                }
                ItemMeta itemMeta = meta = i instanceof ItemStack ? ((ItemStack)i).getItemMeta() : (ItemMeta)((ItemType)i).getItemMeta();
                if (meta == null) {
                    meta = Bukkit.getItemFactory().getItemMeta(Material.STONE);
                }
                n = this.line != null ? (Number)this.line.getSingle(e) : (Number)null;
                List<String> list = lore = meta.hasLore() ? new ArrayList<String>(meta.getLore()) : new ArrayList();
                if (n != null) break block36;
                if (this.line != null) {
                    return;
                }
                switch (mode) {
                    case SET: {
                        assert (delta != null);
                        lore = Arrays.asList((String)delta[0]);
                        break;
                    }
                    case ADD: {
                        assert (delta != null);
                        lore.add((String)delta[0]);
                        break;
                    }
                    case DELETE: {
                        lore = null;
                        break;
                    }
                    case REMOVE: 
                    case REMOVE_ALL: {
                        assert (delta != null);
                        if (SkriptConfig.caseSensitive.value().booleanValue()) {
                            lore = Arrays.asList((mode == Changer.ChangeMode.REMOVE ? StringUtils.join(lore, "\n").replaceFirst(Pattern.quote((String)delta[0]), "") : StringUtils.join(lore, "\n").replace((CharSequence)delta[0], "")).split("\n"));
                            break;
                        }
                        Matcher m = Pattern.compile(Pattern.quote((String)delta[0]), 66).matcher(StringUtils.join(lore, "\n"));
                        lore = Arrays.asList((mode == Changer.ChangeMode.REMOVE ? m.replaceFirst("") : m.replaceAll("")).split("\n"));
                        break;
                    }
                    case RESET: {
                        assert (false);
                        {
                            break;
                        }
                    }
                }
                break block37;
            }
            int l = Math2.fit(0, n.intValue() - 1, 99);
            int j = lore.size();
            while (j <= l) {
                lore.add("");
                ++j;
            }
            switch (mode) {
                case SET: {
                    assert (delta != null);
                    lore.set(l, (String)delta[0]);
                    break;
                }
                case DELETE: {
                    lore.remove(l);
                    break;
                }
                case ADD: {
                    assert (delta != null);
                    lore.set(l, String.valueOf((String)lore.get(l)) + (String)delta[0]);
                    break;
                }
                case REMOVE: 
                case REMOVE_ALL: {
                    assert (delta != null);
                    if (SkriptConfig.caseSensitive.value().booleanValue()) {
                        lore.set(l, mode == Changer.ChangeMode.REMOVE ? ((String)lore.get(l)).replaceFirst(Pattern.quote((String)delta[0]), "") : ((String)lore.get(l)).replace((CharSequence)delta[0], ""));
                        break;
                    }
                    Matcher m = Pattern.compile(Pattern.quote((String)delta[0]), 66).matcher((CharSequence)lore.get(l));
                    lore.set(l, mode == Changer.ChangeMode.REMOVE ? m.replaceFirst("") : m.replaceAll(""));
                    break;
                }
                case RESET: {
                    assert (false);
                    return;
                }
            }
        }
        meta.setLore(lore == null || lore.size() == 0 ? null : lore);
        if (i instanceof ItemStack) {
            ((ItemStack)i).setItemMeta(meta);
        } else {
            ((ItemType)i).setItemMeta(meta);
        }
        if (Changer.ChangerUtils.acceptsChange(this.item, Changer.ChangeMode.SET, i.getClass())) {
            Object[] objectArray;
            if (i instanceof ItemStack) {
                ItemStack[] itemStackArray = new ItemStack[1];
                objectArray = itemStackArray;
                itemStackArray[0] = (ItemStack)i;
            } else {
                ItemType[] itemTypeArray = new ItemType[1];
                objectArray = itemTypeArray;
                itemTypeArray[0] = (ItemType)i;
            }
            this.item.change(e, objectArray, Changer.ChangeMode.SET);
        } else {
            Object[] objectArray;
            if (i instanceof ItemStack) {
                Object[] objectArray2 = new ItemType[1];
                objectArray = objectArray2;
                objectArray2[0] = new ItemType((ItemStack)i);
            } else {
                ItemStack[] itemStackArray = new ItemStack[1];
                objectArray = itemStackArray;
                itemStackArray[0] = ((ItemType)i).getRandom();
            }
            this.item.change(e, objectArray, Changer.ChangeMode.SET);
        }
    }

    @Override
    public boolean isSingle() {
        return true;
    }
}

