/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemData;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.iterator.SingleItemIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.bukkit.Material;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Id")
@Description(value={"The id of a specific item. You usually don't need this expression as you can likely do everything with aliases."})
@Examples(value={"message \"the ID of %type of the clicked block% is %id of the clicked block%.\""})
@Since(value="1.0")
public class ExprIdOf
extends PropertyExpression<ItemType, Integer> {
    private boolean single = false;
    boolean changeItemStack;

    static {
        Skript.registerExpression(ExprIdOf.class, Integer.class, ExpressionType.PROPERTY, "[the] id(1\u00a6s|) of %itemtype%", "%itemtype%'[s] id(1\u00a6s|)");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.setExpr(vars[0]);
        if (parser.mark != 1) {
            this.single = true;
            if (!this.getExpr().isSingle() || this.getExpr() instanceof Literal && ((ItemType)((Literal)this.getExpr()).getSingle()).getTypes().size() != 1) {
                Skript.warning("'" + this.getExpr() + "' has multiple ids");
                this.single = false;
            }
        }
        return true;
    }

    protected Integer[] get(Event e, ItemType[] source) {
        if (this.single) {
            ItemType t = (ItemType)this.getExpr().getSingle(e);
            if (t == null) {
                return new Integer[0];
            }
            return new Integer[]{t.getTypes().get(0).getId()};
        }
        ArrayList<Integer> r = new ArrayList<Integer>();
        ItemType[] itemTypeArray = source;
        int n = source.length;
        int n2 = 0;
        while (n2 < n) {
            ItemType t = itemTypeArray[n2];
            for (ItemData d : t) {
                r.add(d.getId());
            }
            ++n2;
        }
        return r.toArray(new Integer[r.size()]);
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "the id" + (this.single ? "" : "s") + " of " + this.getExpr().toString(e, debug);
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (!this.getExpr().isSingle()) {
            return null;
        }
        if (!Changer.ChangerUtils.acceptsChange(this.getExpr(), Changer.ChangeMode.SET, ItemStack.class, ItemType.class)) {
            return null;
        }
        this.changeItemStack = Changer.ChangerUtils.acceptsChange(this.getExpr(), Changer.ChangeMode.SET, ItemStack.class);
        switch (mode) {
            case ADD: 
            case SET: 
            case REMOVE: {
                return new Class[]{Number.class};
            }
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        assert (delta != null);
        int i = ((Number)delta[0]).intValue();
        ItemType it = (ItemType)this.getExpr().getSingle(e);
        if (it == null) {
            return;
        }
        ItemStack is = it.getRandom();
        if (is == null) {
            return;
        }
        int type = is.getTypeId();
        switch (mode) {
            case ADD: {
                type += i;
                break;
            }
            case REMOVE: {
                type -= i;
                break;
            }
            case SET: {
                type = i;
                break;
            }
            default: {
                assert (false);
                return;
            }
        }
        Material m = Material.getMaterial((int)type);
        if (m != null) {
            is.setType(m);
            if (this.changeItemStack) {
                this.getExpr().change(e, new ItemStack[]{is}, Changer.ChangeMode.SET);
            } else {
                this.getExpr().change(e, new ItemType[]{new ItemType(is)}, Changer.ChangeMode.SET);
            }
        }
    }

    @Override
    @Nullable
    public Iterator<Integer> iterator(Event e) {
        if (this.single) {
            ItemType t = (ItemType)this.getExpr().getSingle(e);
            if (t == null) {
                return null;
            }
            if (t.numTypes() == 0) {
                return null;
            }
            return new SingleItemIterator<Integer>(t.getTypes().get(0).getId());
        }
        final Iterator iter = this.getExpr().iterator(e);
        if (iter == null || !iter.hasNext()) {
            return null;
        }
        return new Iterator<Integer>(){
            private Iterator<ItemData> current;
            {
                this.current = ((ItemType)iterator2.next()).iterator();
            }

            @Override
            public boolean hasNext() {
                while (iter.hasNext() && !this.current.hasNext()) {
                    this.current = ((ItemType)iter.next()).iterator();
                }
                return this.current.hasNext();
            }

            @Override
            public Integer next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.current.next().getId();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Class<Integer> getReturnType() {
        return Integer.class;
    }

    @Override
    public boolean isLoopOf(String s) {
        return s.equalsIgnoreCase("id");
    }
}

