/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.events.bukkit;

import ch.njol.skript.registrations.EventValues;
import ch.njol.skript.util.Experience;
import ch.njol.skript.util.Getter;
import org.bukkit.Location;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;

public class ExperienceSpawnEvent
extends Event
implements Cancellable {
    private int xp;
    private final Location l;
    private boolean cancelled = false;
    private static final HandlerList handlers;

    static {
        EventValues.registerEventValue(ExperienceSpawnEvent.class, Location.class, new Getter<Location, ExperienceSpawnEvent>(){

            @Override
            public Location get(ExperienceSpawnEvent e) {
                return e.getLocation();
            }
        }, 0);
        EventValues.registerEventValue(ExperienceSpawnEvent.class, Experience.class, new Getter<Experience, ExperienceSpawnEvent>(){

            @Override
            public Experience get(ExperienceSpawnEvent e) {
                return new Experience(e.getSpawnedXP());
            }
        }, 0);
        handlers = new HandlerList();
    }

    public ExperienceSpawnEvent(int xp, Location l) {
        this.xp = xp;
        this.l = l;
    }

    public int getSpawnedXP() {
        return this.xp;
    }

    public void setSpawnedXP(int xp) {
        this.xp = Math.max(0, xp);
    }

    public Location getLocation() {
        return this.l;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }
}

