/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.localization;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAddon;
import ch.njol.skript.config.Config;
import ch.njol.skript.localization.LanguageChangeListener;
import ch.njol.skript.util.ExceptionUtils;
import ch.njol.skript.util.Version;
import ch.njol.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import org.bukkit.plugin.Plugin;
import org.eclipse.jdt.annotation.Nullable;

public class Language {
    public static final int F_PLURAL = 1;
    public static final int F_DEFINITE_ARTICLE = 2;
    public static final int F_INDEFINITE_ARTICLE = 4;
    public static final int NO_ARTICLE_MASK = -7;
    private static String name = "english";
    static final HashMap<String, String> english = new HashMap();
    @Nullable
    static HashMap<String, String> localized = null;
    static boolean useLocal = false;
    private static HashMap<Plugin, Version> langVersion = new HashMap();
    private static final Pattern listSplitPattern = Pattern.compile("\\s*,\\s*");
    private static final List<LanguageChangeListener> listeners = new ArrayList<LanguageChangeListener>();
    private static final int[] priorityStartIndices = new int[LanguageListenerPriority.values().length];

    public static String getName() {
        return useLocal ? name : "english";
    }

    @Nullable
    private static final String get_i(String key) {
        String s;
        if (useLocal && localized != null && (s = localized.get(key)) != null) {
            return s;
        }
        s = english.get(key);
        if (s == null && Skript.testing()) {
            Language.missingEntryError(key);
        }
        return s;
    }

    public static String get(String key) {
        String s = Language.get_i(key.toLowerCase(Locale.ENGLISH));
        return s == null ? key.toLowerCase(Locale.ENGLISH) : s;
    }

    @Nullable
    public static String get_(String key) {
        return Language.get_i(key.toLowerCase(Locale.ENGLISH));
    }

    public static final void missingEntryError(String key) {
        Skript.error("Missing entry '" + key.toLowerCase(Locale.ENGLISH) + "' in the default english language file");
    }

    public static String format(String key, Object ... args) {
        String value = Language.get_i(key = key.toLowerCase(Locale.ENGLISH));
        if (value == null) {
            return key;
        }
        try {
            return String.format(value, args);
        }
        catch (Exception e) {
            Skript.error("Invalid format string at '" + key + "' in the " + Language.getName() + " language file: " + value);
            return key;
        }
    }

    public static String getSpaced(String key) {
        String s = Language.get(key);
        if (s.isEmpty()) {
            return " ";
        }
        return " " + s + " ";
    }

    public static String[] getList(String key) {
        String s = Language.get_i(key.toLowerCase(Locale.ENGLISH));
        if (s == null) {
            return new String[]{key.toLowerCase(Locale.ENGLISH)};
        }
        String[] r = listSplitPattern.split(s);
        assert (r != null);
        return r;
    }

    public static boolean keyExists(String key) {
        return english.containsKey(key.toLowerCase(Locale.ENGLISH));
    }

    public static void loadDefault(SkriptAddon addon) {
        HashMap<String, String> en;
        if (addon.getLanguageFileDirectory() == null) {
            return;
        }
        InputStream din = addon.plugin.getResource(String.valueOf(addon.getLanguageFileDirectory()) + "/english.lang");
        if (din == null) {
            throw new IllegalStateException(addon + " is missing the required english.lang file!");
        }
        try {
            try {
                en = new Config(din, "english.lang", false, false, ":").toMap(".");
            }
            catch (Exception e) {
                throw Skript.exception((Throwable)e, "Could not load " + addon + "'s default language file!");
            }
        }
        finally {
            try {
                din.close();
            }
            catch (IOException iOException) {}
        }
        String v = en.get("version");
        if (v == null) {
            Skript.warning("Missing version in english.lang");
        }
        langVersion.put((Plugin)addon.plugin, v == null ? Skript.getVersion() : new Version(v));
        en.remove("version");
        english.putAll(en);
        for (LanguageChangeListener l : listeners) {
            l.onLanguageChange();
        }
    }

    public static boolean load(String name) {
        if ((name = name.toLowerCase()).equals("english")) {
            return true;
        }
        localized = new HashMap();
        boolean exists = Language.load(Skript.getAddonInstance(), name);
        for (SkriptAddon addon : Skript.getAddons()) {
            assert (addon != null);
            exists |= Language.load(addon, name);
        }
        if (!exists) {
            localized = null;
            Language.name = "english";
            return false;
        }
        Language.name = name;
        Language.validateLocalized();
        if (useLocal) {
            for (LanguageChangeListener l : listeners) {
                l.onLanguageChange();
            }
        }
        return true;
    }

    private static boolean load(SkriptAddon addon, String name) {
        HashMap<String, String> l;
        block14: {
            if (addon.getLanguageFileDirectory() == null) {
                return false;
            }
            l = Language.load(addon.plugin.getResource(String.valueOf(addon.getLanguageFileDirectory()) + "/" + name + ".lang"), name);
            File f = new File(addon.plugin.getDataFolder(), String.valueOf(addon.getLanguageFileDirectory()) + File.separator + name + ".lang");
            try {
                if (f.exists()) {
                    l.putAll(Language.load(new FileInputStream(f), name));
                }
            }
            catch (FileNotFoundException e) {
                if ($assertionsDisabled) break block14;
                throw new AssertionError();
            }
        }
        if (l.isEmpty()) {
            return false;
        }
        if (!l.containsKey("version")) {
            Skript.error(addon + "'s language file " + name + ".lang does not provide a version number!");
        } else {
            try {
                Version v = new Version(l.get("version"));
                Version lv = langVersion.get(addon.plugin);
                assert (lv != null);
                if (v.isSmallerThan(lv)) {
                    Skript.warning(addon + "'s language file " + name + ".lang is outdated, some messages will be english.");
                }
            }
            catch (IllegalArgumentException e) {
                Skript.error("Illegal version syntax in " + addon + "'s language file " + name + ".lang: " + e.getLocalizedMessage());
            }
        }
        l.remove("version");
        HashMap<String, String> loc = localized;
        if (loc != null) {
            loc.putAll(l);
        } else assert (false) : addon + "; " + name;
        return true;
    }

    private static HashMap<String, String> load(@Nullable InputStream in, String name) {
        if (in == null) {
            return new HashMap<String, String>();
        }
        try {
            HashMap<String, String> hashMap = new Config(in, String.valueOf(name) + ".lang", false, false, ":").toMap(".");
            return hashMap;
        }
        catch (IOException e) {
            Skript.exception((Throwable)e, "Could not load the language file '" + name + ".lang': " + ExceptionUtils.toString(e));
            HashMap<String, String> hashMap = new HashMap<String, String>();
            return hashMap;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static void validateLocalized() {
        HashMap<String, String> loc = localized;
        if (loc == null) {
            assert (false);
            return;
        }
        HashSet<String> s = new HashSet<String>(english.keySet());
        s.removeAll(loc.keySet());
        Language.removeIgnored(s);
        if (!s.isEmpty() && Skript.logNormal()) {
            Skript.warning("The following messages have not been translated to " + name + ": " + StringUtils.join(s, ", "));
        }
        s = new HashSet<String>(loc.keySet());
        s.removeAll(english.keySet());
        Language.removeIgnored(s);
        if (!s.isEmpty() && Skript.logHigh()) {
            Skript.warning("The localized language file(s) has/ve superfluous entries: " + StringUtils.join(s, ", "));
        }
    }

    private static final void removeIgnored(Set<String> keys2) {
        Iterator<String> i = keys2.iterator();
        while (i.hasNext()) {
            if (!i.next().startsWith("genders.")) continue;
            i.remove();
        }
    }

    public static void addListener(LanguageChangeListener l) {
        Language.addListener(l, LanguageListenerPriority.NORMAL);
    }

    public static void addListener(LanguageChangeListener l, LanguageListenerPriority priority) {
        assert (priority != null);
        listeners.add(priorityStartIndices[priority.ordinal()], l);
        int i = priority.ordinal() + 1;
        while (i < LanguageListenerPriority.values().length) {
            int n = i++;
            priorityStartIndices[n] = priorityStartIndices[n] + 1;
        }
        if (!english.isEmpty()) {
            if (localized != null && useLocal) {
                useLocal = false;
                l.onLanguageChange();
                useLocal = true;
            }
            l.onLanguageChange();
        }
    }

    public static boolean setUseLocal(boolean b) {
        if (useLocal == b) {
            return b;
        }
        if (localized == null) {
            return false;
        }
        useLocal = b;
        for (LanguageChangeListener l : listeners) {
            try {
                l.onLanguageChange();
            }
            catch (Exception e) {
                Skript.exception((Throwable)e, "Error while changing the language " + (b ? "from english to" : "to english from") + " " + name, "Listener: " + l);
            }
        }
        return !b;
    }

    public static boolean isUsingLocal() {
        return useLocal;
    }

    public static enum LanguageListenerPriority {
        EARLIEST,
        NORMAL,
        LATEST;

    }
}

