/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.log;

import ch.njol.skript.Skript;
import ch.njol.skript.config.Node;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.log.HandlerList;
import ch.njol.skript.log.LogEntry;
import ch.njol.skript.log.LogHandler;
import ch.njol.skript.log.ParseLogHandler;
import ch.njol.skript.log.RetainingLogHandler;
import ch.njol.skript.log.Verbosity;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.eclipse.jdt.annotation.Nullable;

public abstract class SkriptLogger {
    public static final Level SEVERE = Level.SEVERE;
    @Nullable
    private static Node node = null;
    private static Verbosity verbosity = Verbosity.NORMAL;
    static boolean debug;
    public static final Level DEBUG;
    public static final Logger LOGGER;
    private static final HandlerList handlers;

    static {
        DEBUG = Level.INFO;
        LOGGER = Bukkit.getServer() != null ? Bukkit.getLogger() : Logger.getLogger("global");
        handlers = new HandlerList();
    }

    public static final RetainingLogHandler startRetainingLog() {
        return SkriptLogger.startLogHandler(new RetainingLogHandler());
    }

    public static final ParseLogHandler startParseLogHandler() {
        return SkriptLogger.startLogHandler(new ParseLogHandler());
    }

    public static final <T extends LogHandler> T startLogHandler(T h) {
        return h;
    }

    static final void removeHandler(LogHandler h) {
        if (!handlers.contains(h)) {
            return;
        }
        if (!h.equals(handlers.remove())) {
            int i = 1;
            while (!h.equals(handlers.remove())) {
                ++i;
            }
            LOGGER.severe("[Skript] " + i + " log handler" + (i == 1 ? " was" : "s were") + " not stopped properly! (at " + SkriptLogger.getCaller() + ") [if you're a server admin and you see this message please file a bug report at https://github.com/bensku/skript/issues if there is not already one]");
        }
    }

    static final boolean isStopped(LogHandler h) {
        return !handlers.contains(h);
    }

    @Nullable
    static final StackTraceElement getCaller() {
        StackTraceElement[] stackTraceElementArray = new Exception().getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement e = stackTraceElementArray[n2];
            if (!e.getClassName().startsWith(SkriptLogger.class.getPackage().getName())) {
                return e;
            }
            ++n2;
        }
        return null;
    }

    public static void setVerbosity(Verbosity v) {
        verbosity = v;
        if (v.compareTo(Verbosity.DEBUG) >= 0) {
            debug = true;
        }
    }

    public static void setNode(@Nullable Node node) {
        SkriptLogger.node = node == null || node.getParent() == null ? null : node;
    }

    @Nullable
    public static Node getNode() {
        return node;
    }

    public static void log(Level level, String message) {
        SkriptLogger.log(new LogEntry(level, message, node));
    }

    public static void log(@Nullable LogEntry entry) {
        if (entry == null) {
            return;
        }
        if (Skript.testing() && node != null && node.debug()) {
            System.out.print("---> " + entry.level + "/" + (Object)((Object)ErrorQuality.get(entry.quality)) + ": " + entry.getMessage() + " ::" + LogEntry.findCaller());
        }
        for (LogHandler h : handlers) {
            LogHandler.LogResult r = h.log(entry);
            switch (r) {
                case CACHED: {
                    return;
                }
                case DO_NOT_LOG: {
                    entry.discarded("denied by " + h);
                    return;
                }
            }
        }
        entry.logged();
        LOGGER.log(entry.getLevel(), "[Skript] " + entry.getMessage());
    }

    public static void logAll(Collection<LogEntry> entries) {
        for (LogEntry entry : entries) {
            if (entry == null) continue;
            SkriptLogger.log(entry);
        }
    }

    public static void logTracked(Level level, String message, ErrorQuality quality) {
        SkriptLogger.log(new LogEntry(level, quality.quality(), message, node, true));
    }

    public static boolean log(Verbosity minVerb) {
        return minVerb.compareTo(verbosity) <= 0;
    }

    public static boolean debug() {
        return debug;
    }
}

