/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.VariableString;
import ch.njol.skript.util.chat.BungeeConverter;
import ch.njol.skript.util.chat.MessageComponent;
import ch.njol.util.Kleenean;
import java.util.List;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Message")
@Description(value={"Sends a message to the given player."})
@Examples(value={"message \"A wild %player% appeared!\"", "message \"This message is a distraction. Mwahaha!\"", "send \"Your kill streak is %{kill streak.%player%}%.\" to player", "if the targeted entity exists:", "\tmessage \"You're currently looking at a %type of the targeted entity%!\""})
@Since(value="1.0, 2.2-dev26 (advanced features)")
public class EffMessage
extends Effect {
    @Nullable
    private Expression<String> messages;
    private boolean canSendRaw;
    private Expression<CommandSender> recipients;

    static {
        Skript.registerEffect(EffMessage.class, "(message|send [message]) %strings% [to %commandsenders%]");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.messages = exprs[0];
        this.canSendRaw = this.messages instanceof VariableString;
        this.recipients = exprs[1];
        return true;
    }

    @Override
    protected void execute(Event e) {
        assert (this.messages != null);
        if (this.canSendRaw) {
            assert (this.messages != null);
            List<MessageComponent> componentList = ((VariableString)this.messages).getMessageComponents(e);
            BaseComponent[] components = BungeeConverter.convert(componentList.toArray(new MessageComponent[componentList.size()]));
            CommandSender[] commandSenderArray = this.recipients.getArray(e);
            int n = commandSenderArray.length;
            int n2 = 0;
            while (n2 < n) {
                CommandSender s = commandSenderArray[n2];
                if (s instanceof Player) {
                    ((Player)s).spigot().sendMessage(components);
                } else {
                    assert (this.messages != null);
                    s.sendMessage(this.messages.getSingle(e));
                }
                ++n2;
            }
        } else {
            assert (this.messages != null);
            String[] stringArray = this.messages.getArray(e);
            int n = stringArray.length;
            int n3 = 0;
            while (n3 < n) {
                String message = stringArray[n3];
                CommandSender[] commandSenderArray = this.recipients.getArray(e);
                int n4 = commandSenderArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    CommandSender s = commandSenderArray[n5];
                    s.sendMessage(message);
                    ++n5;
                }
                ++n3;
            }
        }
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        assert (this.messages != null);
        return "send " + this.messages.toString(e, debug) + " to " + this.recipients.toString(e, debug);
    }
}

