/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skriptaddon.hooksk.util.plugin;

import ch.njol.skript.Skript;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.util.SimpleEvent;
import ch.njol.skript.lang.util.SimpleExpression;
import com.w00tmast3r.skriptaddon.hooksk.util.plugin.HookAPIException;
import com.w00tmast3r.skriptaddon.hooksk.util.skript.EventLoadable;
import com.w00tmast3r.skriptaddon.hooksk.util.skript.ExpressionLoadable;
import com.w00tmast3r.skriptaddon.hooksk.util.skript.Loadable;
import java.beans.Expression;
import org.bukkit.Bukkit;

public class HookUtils {
    @SafeVarargs
    public static void registerPluginClasses(String plugin, Class<? extends Loadable> ... classes) {
        if (Bukkit.getPluginManager().getPlugin(plugin) != null) {
            Bukkit.getLogger().info("Registered " + String.valueOf(HookUtils.registerClasses(classes)) + " classes for the plugin " + plugin);
        } else {
            Bukkit.getLogger().info("Failed to register hooks for " + plugin);
        }
    }

    @SafeVarargs
    public static int registerClasses(Class<? extends Loadable> ... classes) {
        int i = 0;
        try {
            for (Class<? extends Loadable> c : classes) {
                Loadable l = c.newInstance();
                if (Effect.class.isAssignableFrom(c)) {
                    Skript.registerEffect(c, (String[])l.getPatterns());
                    ++i;
                    continue;
                }
                if (Condition.class.isAssignableFrom(c)) {
                    Skript.registerCondition(c, (String[])l.getPatterns());
                    ++i;
                    continue;
                }
                if (Expression.class.isAssignableFrom(c) || SimpleExpression.class.isAssignableFrom(c) || PropertyExpression.class.isAssignableFrom(c) || SimplePropertyExpression.class.isAssignableFrom(c)) {
                    if (l instanceof ExpressionLoadable) {
                        Skript.registerExpression(c, (Class)((ExpressionLoadable)l).getReturnType(), (ExpressionType)((ExpressionLoadable)l).getExpressionType(), (String[])l.getPatterns());
                        ++i;
                        continue;
                    }
                    throw new HookAPIException(c.getName() + " should extend ExpressionLoadable instead of Loadable");
                }
                if (SkriptEvent.class.isAssignableFrom(c) || SimpleEvent.class.isAssignableFrom(c)) {
                    if (l instanceof EventLoadable) {
                        Skript.registerEvent((String)((EventLoadable)l).getEventName(), c, ((EventLoadable)l).getEvent(), (String[])l.getPatterns());
                        ((EventLoadable)l).postRegisterEventData();
                        ++i;
                        continue;
                    }
                    throw new HookAPIException(c.getName() + " should extend EventLoadable instead of Loadable");
                }
                throw new HookAPIException(c.getName() + " does not extend a Skript class");
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
        return i;
    }
}

