/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.hda.utils;

import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.localization.Language;
import ch.njol.skript.util.EnumUtils;
import java.util.ArrayList;
import java.util.Arrays;
import me.limeglass.hda.HolographicDisplaysAddon;
import me.limeglass.hda.lang.HDAParser;
import org.eclipse.jdt.annotation.Nullable;

public class LangEnumParser<T extends Enum<T>>
extends HDAParser<T> {
    private EnumUtils<T> enumUtil;
    private final Class<T> clazz;
    private final String codeName;

    public LangEnumParser(String variableNamePattern, Class<T> clazz) {
        super(variableNamePattern);
        this.clazz = clazz;
        this.codeName = variableNamePattern;
        try {
            this.enumUtil = new EnumUtils(clazz, String.valueOf(variableNamePattern) + "s");
            ArrayList<String> enumNames = new ArrayList<String>();
            Enum[] enumArray = (Enum[])clazz.getEnumConstants();
            int n = enumArray.length;
            int n2 = 0;
            while (n2 < n) {
                Enum e = enumArray[n2];
                enumNames.addAll(Arrays.asList(Language.get_((String)(String.valueOf(variableNamePattern) + "s" + "." + e.name()))));
                ++n2;
            }
            HolographicDisplaysAddon.getConfiguration("syntax").set("Syntax.Enums." + clazz.getSimpleName() + ".names", enumNames);
        }
        catch (NullPointerException error) {
            HolographicDisplaysAddon.consoleMessage("&cThe class: " + clazz.getName() + " for classinfo name: " + variableNamePattern + " isn't an Enum!");
        }
        HolographicDisplaysAddon.save("syntax");
    }

    @Nullable
    public T parse(String string, ParseContext parseContent) {
        Enum result;
        if (string.startsWith(String.valueOf(this.codeName) + ":")) {
            string = string.substring(this.codeName.length() + 1, string.length());
        }
        string = string.replaceAll("_", " ");
        Enum enum_ = result = this.enumUtil != null ? this.enumUtil.parse(string) : null;
        if (result != null) {
            return (T)result;
        }
        string = string.replaceAll(" ", "_");
        try {
            return Enum.valueOf(this.clazz, string.toUpperCase());
        }
        catch (IllegalArgumentException error) {
            return null;
        }
    }

    @Override
    public String toString(T t, int i) {
        return ((Enum)t).name().toLowerCase().replaceAll("_", " ");
    }

    @Override
    public String toVariableNameString(T t) {
        return String.valueOf(this.codeName) + ':' + ((Enum)t).toString();
    }

    @Override
    public String getVariableNamePattern() {
        return String.valueOf(this.codeName) + ":.+";
    }
}

