/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.hda.elements.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import com.gmail.filoghost.holographicdisplays.api.Hologram;
import java.util.ArrayList;
import me.limeglass.hda.lang.HDAPropertyExpression;
import me.limeglass.hda.utils.annotations.Changers;
import me.limeglass.hda.utils.annotations.Properties;
import me.limeglass.hda.utils.annotations.PropertiesAddition;
import org.bukkit.event.Event;

@Name(value="Hologram placeholder toggle")
@Description(value={"Returns a boolean that sets if the hologram(s) should support placeholders or not."})
@Properties(value={"holograms", "[allowing] placeholders"})
@PropertiesAddition(value="[the] holo[gra(m|phic display)][s]")
@Changers(value={Changer.ChangeMode.SET})
public class ExprHologramPlaceholders
extends HDAPropertyExpression<Hologram, Boolean> {
    protected Boolean[] get(Event event, Hologram[] holograms) {
        if (this.isNull(event).booleanValue()) {
            return null;
        }
        ArrayList<Boolean> allowing = new ArrayList<Boolean>();
        Hologram[] hologramArray = holograms;
        int n = holograms.length;
        int n2 = 0;
        while (n2 < n) {
            Hologram hologram = hologramArray[n2];
            allowing.add(hologram.isAllowPlaceholders());
            ++n2;
        }
        return allowing.toArray(new Boolean[allowing.size()]);
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        if (this.isNull(event).booleanValue() || delta == null) {
            return;
        }
        Hologram[] hologramArray = this.expressions.getAll(event, Hologram.class);
        int n = hologramArray.length;
        int n2 = 0;
        while (n2 < n) {
            Hologram hologram = hologramArray[n2];
            hologram.setAllowPlaceholders(((Boolean)delta[0]).booleanValue());
            ++n2;
        }
    }
}

