/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.hda;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAddon;
import com.gmail.filoghost.holographicdisplays.api.Hologram;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import me.limeglass.hda.Metrics;
import me.limeglass.hda.elements.Register;
import me.limeglass.hda.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class HolographicDisplaysAddon
extends JavaPlugin {
    private static Map<String, FileConfiguration> files = new HashMap<String, FileConfiguration>();
    public HashMap<String, Hologram> holograms = new HashMap();
    private String packageName = "me.limeglass.hda";
    private static String prefix = "&8[&5HolographicAddon&8] &d";
    private String nameplate = "[HolographicAddon] ";
    private static HolographicDisplaysAddon instance;
    private SkriptAddon addon;
    private Metrics metrics;

    public void onEnable() {
        this.addon = Skript.registerAddon((JavaPlugin)this).setLanguageFileDirectory("lang");
        instance = this;
        this.saveDefaultConfig();
        File config = new File(this.getDataFolder(), "config.yml");
        if (!Objects.equals(this.getDescription().getVersion(), this.getConfig().getString("version"))) {
            HolographicDisplaysAddon.consoleMessage("&aNew update found! Updating files now...");
            if (config.exists()) {
                config.delete();
            }
        }
        for (String name : Arrays.asList("config", "syntax")) {
            File file = new File(this.getDataFolder(), String.valueOf(name) + ".yml");
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                this.saveResource(file.getName(), false);
            }
            YamlConfiguration configuration = new YamlConfiguration();
            try {
                configuration.load(file);
            }
            catch (IOException | InvalidConfigurationException e) {
                e.printStackTrace();
            }
            files.put(name, (FileConfiguration)configuration);
        }
        this.metrics = new Metrics(this);
        Register.register();
        if (!this.getConfig().getBoolean("DisableRegisteredInfo", false)) {
            Bukkit.getLogger().info(String.valueOf(this.nameplate) + "has been enabled!");
        }
    }

    public static HolographicDisplaysAddon getInstance() {
        return instance;
    }

    public SkriptAddon getAddonInstance() {
        return this.addon;
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getNameplate() {
        return this.nameplate;
    }

    public String getPrefix() {
        return prefix;
    }

    public static FileConfiguration getConfiguration(String file) {
        return files.containsKey(file) ? files.get(file) : null;
    }

    public static void save(String configuration) {
        try {
            File configurationFile = new File(instance.getDataFolder(), String.valueOf(configuration) + ".yml");
            HolographicDisplaysAddon.getConfiguration(configuration).save(configurationFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void debugMessage(String text) {
        if (instance.getConfig().getBoolean("debug")) {
            HolographicDisplaysAddon.consoleMessage("&b" + text);
        }
    }

    public static void consoleMessage(String ... messages) {
        String[] stringArray = messages;
        int n = messages.length;
        int n2 = 0;
        while (n2 < n) {
            String text = stringArray[n2];
            Bukkit.getConsoleSender().sendMessage(Utils.cc(String.valueOf(prefix) + text));
            ++n2;
        }
    }
}

