/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.hda.elements.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import com.gmail.filoghost.holographicdisplays.api.Hologram;
import com.gmail.filoghost.holographicdisplays.api.VisibilityManager;
import java.util.ArrayList;
import java.util.Arrays;
import me.limeglass.hda.lang.HDAPropertyExpression;
import me.limeglass.hda.utils.annotations.AllChangers;
import me.limeglass.hda.utils.annotations.Multiple;
import me.limeglass.hda.utils.annotations.Properties;
import me.limeglass.hda.utils.annotations.PropertiesAddition;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Name(value="Hologram viewers")
@Description(value={"A modifiable list of players that can view the hologram."})
@Properties(value={"hologram", "[all [[of] the]] (viewer[s]|visibil(e|ity) [list])"})
@PropertiesAddition(value="[the] holo[gra(m|phic display)][s]")
@AllChangers
@Multiple
public class ExprHologramVisibility
extends HDAPropertyExpression<Hologram, Player> {
    protected Player[] get(Event event, Hologram[] holograms) {
        if (this.isNull(event).booleanValue()) {
            return null;
        }
        ArrayList<Player> players = new ArrayList<Player>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!this.expressions.getSingle(event, Hologram.class).getVisibilityManager().isVisibleTo(player)) continue;
            players.add(player);
        }
        return players.toArray(new Player[players.size()]);
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        if (this.isNull(event).booleanValue() || delta == null) {
            return;
        }
        Player[] players = (Player[])delta;
        VisibilityManager visibilityManager = this.expressions.getSingle(event, Hologram.class).getVisibilityManager();
        switch (mode) {
            case ADD: {
                Player[] playerArray = players;
                int n = players.length;
                int n2 = 0;
                while (n2 < n) {
                    Player player = playerArray[n2];
                    visibilityManager.showTo(player);
                    ++n2;
                }
                break;
            }
            case DELETE: {
                visibilityManager.resetVisibilityAll();
                break;
            }
            case REMOVE: {
                Player[] playerArray = players;
                int n = players.length;
                int n3 = 0;
                while (n3 < n) {
                    Player player = playerArray[n3];
                    visibilityManager.hideTo(player);
                    ++n3;
                }
                break;
            }
            case REMOVE_ALL: {
                visibilityManager.resetVisibilityAll();
                break;
            }
            case RESET: {
                visibilityManager.resetVisibilityAll();
                break;
            }
            case SET: {
                visibilityManager.resetVisibilityAll();
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (Arrays.asList(players).contains(player)) continue;
                    visibilityManager.hideTo(player);
                }
                break;
            }
        }
    }
}

