/*
 * Decompiled with CFR 0.152.
 */
package dev.moderocky.mirror;

import dev.moderocky.mirror.IMirror;
import dev.moderocky.mirror.Mirror;
import org.jetbrains.annotations.Nullable;

public interface ClassWorker<T>
extends IMirror<T> {
    default public Class<?> getAsClass() {
        Object object = this.getTarget();
        return object instanceof Class ? (Class<?>)object : object.getClass();
    }

    default public <Q> Class<Q> getSuperclass() {
        Object object = this.getTarget();
        return object instanceof Class ? ((Class)object).getSuperclass() : object.getClass().getSuperclass();
    }

    default public <Q> Class<Q> getEnclosingClass() {
        Object object = this.getTarget();
        return object instanceof Class ? ((Class)object).getEnclosingClass() : object.getClass().getEnclosingClass();
    }

    default public <Q> Class<Q> getDeclaringClass() {
        Object object = this.getTarget();
        return object instanceof Class ? ((Class)object).getDeclaringClass() : object.getClass().getDeclaringClass();
    }

    @Nullable
    default public <Q> Q getEnclosingInstance() {
        Object object = this.getTarget();
        Mirror mirror = new Mirror(object);
        if (!mirror.hasField("this$0")) {
            return null;
        }
        return mirror.field("this$0").get();
    }

    default public boolean isLocal() {
        return this.getAsClass().isLocalClass();
    }
}

