/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.util;

import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.command.CommandSender;

public interface Messenger {
    public static ChatColor color(String hex, char def) {
        try {
            return ChatColor.of((String)(hex.startsWith("#") ? hex : "#" + hex));
        }
        catch (Throwable throwable) {
            return ChatColor.getByChar((char)def);
        }
    }

    default public void sendMessage(String text, CommandSender ... players) {
        BaseComponent[] components = new ComponentBuilder("").append(this.getPrefix()).append(TextComponent.fromLegacyText((String)text)).create();
        for (CommandSender player : players) {
            player.spigot().sendMessage(components);
        }
    }

    default public void sendMessage(BaseComponent[] text, CommandSender ... players) {
        BaseComponent[] components = new ComponentBuilder("").append(this.getPrefix()).append(text).create();
        for (CommandSender player : players) {
            player.spigot().sendMessage(components);
        }
    }

    default public BaseComponent[] getBullets(String ... texts) {
        ComponentBuilder builder = new ComponentBuilder("").reset();
        boolean first = true;
        for (String text : texts) {
            builder.append(!first ? System.lineSeparator() : "").reset().append(" - ").color(ChatColor.DARK_GRAY).append("").color(ChatColor.RESET).append(text);
            first = false;
        }
        return builder.append("").reset().create();
    }

    default public BaseComponent[] getBullets(BaseComponent[] ... texts) {
        ComponentBuilder builder = new ComponentBuilder("").reset();
        boolean first = true;
        for (BaseComponent[] text : texts) {
            builder.append(!first ? System.lineSeparator() : "").reset().append(" - ").color(ChatColor.DARK_GRAY).append("").color(ChatColor.RESET).append(text);
            first = false;
        }
        return builder.append("").reset().create();
    }

    default public ChatColor color(ChatColor color, ChatColor def) {
        try {
            return color;
        }
        catch (Throwable throwable) {
            return def;
        }
    }

    public BaseComponent[] getPrefix();
}

