/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.skript.expression;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.moderocky.guardian.Guardian;
import com.moderocky.guardian.api.GuardianAPI;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="Registered Guardian Flags")
@Description(value={"Returns all registered Guardian flags. ", "Flags used by Guardian are togglable protections for zones. "})
@Examples(value={"set {_flags::*} to all registered flags", "add all registered flags to the flags of zone \"my_zone\""})
@Since(value="1.0.4")
public class RegisteredFlagsExpr
extends SimpleExpression<String> {
    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parseResult) {
        return true;
    }

    protected String[] get(@NotNull Event event) {
        GuardianAPI api = Guardian.getApi();
        return api.getProtectionFlags().toArray(new String[0]);
    }

    public boolean isSingle() {
        return false;
    }

    @NotNull
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return "all registered flags";
    }

    static {
        Skript.registerExpression(RegisteredFlagsExpr.class, String.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"([the|all]) registered [guardian] flags"});
    }
}

