/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.mask.template;

import com.moderocky.guardian.mask.annotation.API;
import java.io.InputStream;
import net.md_5.bungee.api.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public interface IPlugin {
    @API
    public void startup();

    @API
    public void disable();

    @API
    default public String getConfigPath() {
        return "plugins/" + this.getName() + "/config.yml";
    }

    default public String getName() {
        if (this.isBukkit()) {
            JavaPlugin plugin = (JavaPlugin)this;
            return plugin.getName();
        }
        Plugin plugin = (Plugin)this;
        return plugin.getDescription().getName();
    }

    default public boolean isBukkit() {
        return this.getPluginType() == PluginType.BUKKIT;
    }

    default public boolean isBungee() {
        return this.getPluginType() == PluginType.BUNGEE;
    }

    default public PluginType getPluginType() {
        try {
            return Class.forName("org.bukkit.plugin.java.JavaPlugin") != null && this instanceof JavaPlugin ? PluginType.BUKKIT : PluginType.BUNGEE;
        }
        catch (Throwable throwable) {
            return PluginType.BUNGEE;
        }
    }

    public InputStream getResource(String var1);

    public static enum PluginType {
        BUKKIT,
        BUNGEE;

    }
}

