/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.mask.mirror;

import com.moderocky.guardian.mask.mirror.ClassWorker;
import com.moderocky.guardian.mask.mirror.ConstructorMirror;
import com.moderocky.guardian.mask.mirror.FieldMirror;
import com.moderocky.guardian.mask.mirror.MethodMirror;
import com.moderocky.guardian.mask.mirror.Package;
import com.moderocky.guardian.mask.mirror.Reflective;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public final class Mirror<T>
implements Reflective,
ClassWorker<T> {
    @NotNull
    private final transient T object;

    public Mirror(@NotNull T object) {
        this.object = object;
    }

    public static boolean classExists(String classPath) {
        try {
            Class.forName(classPath);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static Mirror<?> blank() {
        return new Mirror<Class<Mirror>>(Mirror.class);
    }

    public static <Q> Class<Q> getClass(String classPath) {
        try {
            return Class.forName(classPath);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static <Q> Mirror<Class<Q>> mirror(String classPath) {
        Class<Q> classy = Mirror.getClass(classPath);
        if (classy == null) {
            return null;
        }
        return new Mirror<Class<Q>>(classy);
    }

    @Override
    public <Q extends Annotation> boolean hasAnnotation(Class<Q> annotation) {
        return this.getAsClass().getDeclaredAnnotation(annotation) != null;
    }

    @Override
    public <Q extends Annotation> Q getAnnotation(Class<Q> annotation) {
        return this.getAsClass().getDeclaredAnnotation(annotation);
    }

    @Override
    public int getModifiers() {
        return this.getAsClass().getModifiers();
    }

    public boolean isLocalClass() {
        return this.getAsClass().isLocalClass();
    }

    public boolean isMemberClass() {
        return this.getAsClass().isMemberClass();
    }

    public boolean isSynthetic() {
        return this.getAsClass().isSynthetic();
    }

    public boolean isAnonymous() {
        return this.getAsClass().isAnonymousClass();
    }

    public boolean isAnnotation() {
        return this.getAsClass().isAnnotation();
    }

    @Override
    public boolean isInterface() {
        return this.getAsClass().isInterface();
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.getAsClass().getModifiers());
    }

    @Override
    public boolean isFinal() {
        return Modifier.isFinal(this.getAsClass().getModifiers());
    }

    @Override
    public boolean isPublic() {
        return Modifier.isPublic(this.getAsClass().getModifiers());
    }

    @Override
    public String getName() {
        return this.getAsClass().getName();
    }

    public <Q> Q instantiate(Object ... params) {
        for (Constructor<?> constructor : this.getAsClass().getDeclaredConstructors()) {
            try {
                if (!constructor.isAccessible()) {
                    constructor.setAccessible(true);
                }
                return (Q)constructor.newInstance(params);
            }
            catch (Throwable throwable) {
            }
        }
        return null;
    }

    public <Q> ConstructorMirror<Q> constructor(Class<?> ... params) {
        try {
            return new ConstructorMirror(this.getAsClass().getDeclaredConstructor(params), this, this.object);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public boolean hasConstructor(Class<?> ... params) {
        try {
            return this.getAsClass().getDeclaredConstructor(params) != null;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public <Q> void ifHasConstructor(Consumer<ConstructorMirror<Q>> consumer, Class<?> ... params) {
        if (this.hasConstructor(params)) {
            consumer.accept(this.constructor(params));
        }
    }

    public <Q> FieldMirror<Q> field(String name) {
        return this.field(name, this.getAsClass());
    }

    public <Q> FieldMirror<Q> field(String name, Class<?> actor) {
        try {
            Field field = actor.getDeclaredField(name);
            return this.field(field);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public <Q> FieldMirror<Q> field(Field field) {
        return new FieldMirror(field, this, this.object);
    }

    public boolean hasField(String name) {
        return this.hasField(name, this.getAsClass());
    }

    public boolean hasField(String name, Class<?> actor) {
        try {
            return actor.getDeclaredField(name) != null;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public <Q> void ifHasField(String name, Consumer<FieldMirror<Q>> consumer) {
        if (this.hasField(name)) {
            consumer.accept(this.field(name));
        }
    }

    public <Q> MethodMirror<Q> method(String name, Class<?> ... params) {
        try {
            Method method = this.object instanceof Class ? ((Class)this.object).getDeclaredMethod(name, params) : this.object.getClass().getDeclaredMethod(name, params);
            return this.method(method);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public boolean hasMethod(String name, Class<?> ... params) {
        try {
            return this.object instanceof Class ? ((Class)this.object).getDeclaredMethod(name, params) != null : this.object.getClass().getDeclaredMethod(name, params) != null;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public boolean hasMethod(String name, Object ... params) {
        HashSet classes = new HashSet();
        for (Object param : params) {
            if (param instanceof Class) {
                classes.add((Class)param);
                continue;
            }
            classes.add(param.getClass());
        }
        return this.hasMethod(name, classes.toArray(new Class[0]));
    }

    public <Q> void ifHasMethod(String name, Consumer<MethodMirror<Q>> consumer, Class<?> ... params) {
        if (this.hasMethod(name, new Class[0])) {
            consumer.accept(this.method(name, params));
        }
    }

    public <Q> MethodMirror<Q> method(String name, Object ... params) {
        HashSet classes = new HashSet();
        for (Object param : params) {
            if (param instanceof Class) {
                classes.add((Class)param);
                continue;
            }
            classes.add(param.getClass());
        }
        return this.method(name, classes.toArray(new Class[0]));
    }

    public <Q> MethodMirror<Q> method(Method method) {
        return new MethodMirror(method, this, this.object);
    }

    public <Q extends Annotation> Method[] getMethods(Class<Q> annotation) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : this.getAsClass().getDeclaredMethods()) {
            if (method.getAnnotation(annotation) == null) continue;
            methods.add(method);
        }
        return methods.toArray(new Method[0]);
    }

    public <Q extends Annotation> MethodMirror<?>[] getMethodMirrors(Class<Q> annotation) {
        Method[] methods = this.getMethods(annotation);
        MethodMirror[] mirrors = new MethodMirror[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            mirrors[i] = this.method(methods[i]);
        }
        return mirrors;
    }

    public <Q extends Annotation> Field[] getFields(Class<Q> annotation) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : this.getAsClass().getDeclaredFields()) {
            if (field.getAnnotation(annotation) == null) continue;
            fields.add(field);
        }
        return fields.toArray(new Field[0]);
    }

    public <Q extends Annotation> FieldMirror<?>[] getFieldMirrors(Class<Q> annotation) {
        Field[] fields = this.getFields(annotation);
        FieldMirror[] mirrors = new FieldMirror[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            mirrors[i] = this.field(fields[i]);
        }
        return mirrors;
    }

    public <Q> FieldMirror<Q>[] getFieldMirrors() {
        Field[] fields = this.getAsClass().getDeclaredFields();
        FieldMirror[] mirrors = new FieldMirror[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            mirrors[i] = this.field(fields[i]);
        }
        return mirrors;
    }

    public <Q> MethodMirror<Q>[] getMethodMirrors() {
        Method[] methods = this.getAsClass().getDeclaredMethods();
        MethodMirror[] mirrors = new MethodMirror[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            mirrors[i] = this.method(methods[i]);
        }
        return mirrors;
    }

    public Method[] scanForMethods(Class<?> returnType, Boolean isStatic, Class<?> ... params) {
        ArrayList<Method> methods = new ArrayList<Method>();
        block0: for (Method method : this.getAsClass().getDeclaredMethods()) {
            boolean stat = Modifier.isStatic(method.getModifiers());
            if (isStatic != null && stat ^ isStatic) continue;
            Class<?> cls = method.getReturnType();
            if (method.getParameterCount() != params.length || cls != returnType && !returnType.isAssignableFrom(cls)) continue;
            int i = 0;
            for (Class<?> type : method.getParameterTypes()) {
                if (type != params[i] && !params[i].isAssignableFrom(type)) continue block0;
                ++i;
            }
            methods.add(method);
        }
        return methods.toArray(new Method[0]);
    }

    public MethodMirror<?>[] scanForMethodMirrors(Class<?> returnType, Class<?> ... params) {
        ArrayList methods = new ArrayList();
        Method[] methodArray = this.scanForMethods(returnType, this.object instanceof Class ? Boolean.valueOf(true) : null, params);
        int n = methodArray.length;
        for (int i = 0; i < n; ++i) {
            Method method;
            boolean stat = Modifier.isStatic((method = methodArray[i]).getModifiers());
            methods.add(new MethodMirror(method, this, stat ? this.getAsClass() : this.object));
        }
        return methods.toArray(new MethodMirror[0]);
    }

    public Field[] scanForFields(Class<?> type, Boolean isStatic) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : this.getAsClass().getDeclaredFields()) {
            boolean stat = Modifier.isStatic(field.getModifiers());
            if (isStatic != null && stat ^ isStatic || field.getType() != type && !type.isAssignableFrom(field.getType())) continue;
            fields.add(field);
        }
        return fields.toArray(new Field[0]);
    }

    public FieldMirror<?>[] scanForFieldMirrors(Class<?> type) {
        ArrayList fields = new ArrayList();
        Field[] fieldArray = this.scanForFields(type, this.object instanceof Class ? Boolean.valueOf(true) : null);
        int n = fieldArray.length;
        for (int i = 0; i < n; ++i) {
            Field field;
            boolean stat = Modifier.isStatic((field = fieldArray[i]).getModifiers());
            fields.add(new FieldMirror(field, this, stat ? this.getAsClass() : this.object));
        }
        return fields.toArray(new FieldMirror[0]);
    }

    public <Q> Q invoke(String name, Object ... params) {
        MethodMirror<Q> method = this.method(name, params);
        return method.invoke(params);
    }

    public <Q> Q invokeIf(String name, Object ... params) {
        if (!this.hasMethod(name, params)) {
            return null;
        }
        return this.invoke(name, params);
    }

    public <Q> Mirror<Class<Q>> getInner(String name) {
        for (Class<?> innerClass : this.getInnerClasses()) {
            if (!innerClass.getName().endsWith(name)) continue;
            return new Mirror<Class<Q>>(innerClass);
        }
        return null;
    }

    public Class<?>[] getInnerClasses() {
        return this.getAsClass().getDeclaredClasses();
    }

    public boolean hasInnerClasses() {
        return this.getAsClass().getDeclaredClasses().length > 0;
    }

    public boolean isEnum() {
        return this.getAsClass().isEnum();
    }

    public boolean isArray() {
        return this.getAsClass().isArray();
    }

    public T getEnum(String id) {
        Mirror mirror = new Mirror(this.getAsClass());
        if (!mirror.isEnum()) {
            return null;
        }
        return (T)mirror.invoke("valueOf", id);
    }

    public Package getPackage() {
        return new Package(this.getAsClass().getPackage().getName());
    }

    @Override
    public Mirror<T> getParent() {
        return this;
    }

    @Override
    public T getTarget() {
        return this.object;
    }

    @Override
    public Object getLiteral() {
        return this.object;
    }

    @Override
    public Object getNativeLiteral() {
        return this.getAsClass();
    }
}

