/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.mask.mirror;

import com.moderocky.guardian.mask.mirror.IMirror;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MethodMirror<T>
implements IMirror<T> {
    @NotNull
    private final transient Method method;
    @NotNull
    private final transient IMirror<?> parent;
    @NotNull
    private final transient Object target;

    public MethodMirror(@NotNull Method method, @NotNull IMirror<?> parent, @NotNull Object target) {
        this.method = method;
        this.parent = parent;
        this.target = target;
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
    }

    public T invoke(Object ... params) {
        if (this.target == null) {
            return null;
        }
        try {
            return (T)this.method.invoke(this.target, params);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public void invoke(@Nullable Consumer<T> success, @Nullable Consumer<Throwable> failure, Object ... params) {
        block3: {
            try {
                if (success != null) {
                    success.accept(this.invoke(params));
                }
            }
            catch (Throwable throwable) {
                if (failure == null) break block3;
                failure.accept(throwable);
            }
        }
    }

    public void invoke(Consumer<T> success, Object ... params) {
        this.invoke(success, null, params);
    }

    @Override
    public <Q extends Annotation> boolean hasAnnotation(Class<Q> annotation) {
        return this.method.getDeclaredAnnotation(annotation) != null;
    }

    @Override
    public <Q extends Annotation> Q getAnnotation(Class<Q> annotation) {
        return this.method.getDeclaredAnnotation(annotation);
    }

    public int getParameterCount() {
        return this.method.getParameterCount();
    }

    @Override
    public int getModifiers() {
        return this.method.getModifiers();
    }

    public Class<T> getReturnType() {
        return this.method.getReturnType();
    }

    @Override
    public String getName() {
        return this.method.getName();
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.method.getModifiers());
    }

    @Override
    public boolean isFinal() {
        return Modifier.isFinal(this.method.getModifiers());
    }

    @Override
    public boolean isPublic() {
        return Modifier.isPublic(this.method.getModifiers());
    }

    @Override
    public <Q> IMirror<Q> getParent() {
        return this.parent;
    }

    @Override
    public <Q> Q getTarget() {
        return (Q)this.target;
    }

    @Override
    public Method getLiteral() {
        return this.method;
    }
}

