/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.mask.mirror;

import com.moderocky.guardian.mask.mirror.Mirror;
import com.moderocky.guardian.mask.mirror.Modifiable;
import com.moderocky.guardian.mask.mirror.Reflective;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.function.Consumer;

public interface IMirror<T>
extends Modifiable,
Reflective {
    public <Q> IMirror<Q> getParent();

    public <Q> Q getTarget();

    @Override
    public Object getLiteral();

    @Override
    default public Object getNativeLiteral() {
        return this.getLiteral();
    }

    public <Q extends Annotation> boolean hasAnnotation(Class<Q> var1);

    public <Q extends Annotation> Q getAnnotation(Class<Q> var1);

    @Override
    default public boolean removeModifier(int modifier) {
        return this.modifyAccess(this.getModifiers() & ~modifier);
    }

    @Override
    default public boolean addModifier(int modifier) {
        return this.modifyAccess(this.getModifiers() & modifier);
    }

    @Override
    default public boolean modifyAccess(int modifiers) {
        return this.tryCatch(() -> new Mirror<Object>(this.getNativeLiteral()).field("modifiers").set(modifiers));
    }

    @Override
    public int getModifiers();

    @Override
    public boolean isStatic();

    @Override
    public boolean isFinal();

    @Override
    public boolean isPublic();

    @Override
    default public boolean isPrivate() {
        return Modifier.isPrivate(this.getModifiers());
    }

    @Override
    default public boolean isAbstract() {
        return Modifier.isAbstract(this.getModifiers());
    }

    public String getName();

    default public <Q extends Annotation> void ifHasAnnotation(Class<Q> annotation, Consumer<Q> success) {
        if (this.hasAnnotation(annotation)) {
            success.accept(this.getAnnotation(annotation));
        }
    }
}

