/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.mask.command;

import com.moderocky.guardian.mask.api.MagicList;
import com.moderocky.guardian.mask.api.MagicMap;
import com.moderocky.guardian.mask.api.StringReader;
import com.moderocky.guardian.mask.command.ArgLiteral;
import com.moderocky.guardian.mask.command.ArgLiteralPlural;
import com.moderocky.guardian.mask.command.Argument;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Commander<S> {
    final MagicList<String> patterns = new MagicList();
    final MagicMap<String, @Nullable String> patternDescriptions = new MagicMap();
    final MagicList<String> aliases = new MagicList();
    final ArgumentTree tree = new ArgumentTree();
    private BiFunction<S, Throwable, Boolean> error = null;
    private String namespace;
    private volatile String input;

    public Commander() {
        this.compile();
    }

    final void compile() {
        boolean matches;
        String test;
        String group;
        Matcher matcher;
        this.patterns.clear();
        this.patternDescriptions.clear();
        this.aliases.clear();
        this.tree.clear();
        this.create();
        String regex = "^[^\\[<\\n]+((?> [<\\[]\\S+[\\]>])+)$";
        Pattern pattern = Pattern.compile("^[^\\[<\\n]+((?> [<\\[]\\S+[\\]>])+)$");
        MagicList<String> list = new MagicList<String>((Collection<String>)this.getPossibleArguments(new String[0]));
        Cloneable catcher = new MagicList<String>((Collection<String>)list);
        ((ArrayList)catcher).removeIf(s -> !s.contains("<") && !s.contains("["));
        ((ArrayList)catcher).removeIf(s -> !s.matches("^[^\\[<\\n]+((?> [<\\[]\\S+[\\]>])+)$"));
        for (String string : new ArrayList<String>((Collection<String>)((Object)catcher))) {
            matcher = pattern.matcher(string);
            if (!matcher.find()) continue;
            group = matcher.group(1).trim();
            test = string.replace(group, "").trim();
            matches = false;
            for (String str : new ArrayList<String>(list)) {
                if (!str.trim().equalsIgnoreCase(test)) continue;
                matches = true;
                list.remove(str);
            }
            if (!matches) continue;
            list.remove(string);
            list.add(group.contains("<") ? test + " [" + group + "]" : test + " " + group);
        }
        this.patterns.addAll(list);
        Collections.sort(this.patterns);
        MagicMap<String, String> map = new MagicMap<String, String>(this.getPatternDesc());
        catcher = new MagicMap<String, String>((Map<String, String>)map);
        ((MagicMap)catcher).removeIf(s -> !s.contains("<") && !s.contains("["));
        ((MagicMap)catcher).removeIf(s -> !s.matches("^[^\\[<\\n]+((?> [<\\[]\\S+[\\]>])+)$"));
        for (String string : new ArrayList(((LinkedHashMap)catcher).keySet())) {
            matcher = pattern.matcher(string);
            if (!matcher.find()) continue;
            group = matcher.group(1).trim();
            test = string.replace(group, "").trim();
            matches = false;
            for (String str : new ArrayList(map.keySet())) {
                if (!str.trim().equalsIgnoreCase(test)) continue;
                matches = true;
                map.remove(str);
            }
            if (!matches) continue;
            String desc = (String)map.remove(string);
            map.put(group.contains("<") ? test + " [" + group + "]" : test + " " + group, desc);
        }
        this.patternDescriptions.putAll(map);
    }

    protected abstract CommandImpl create();

    /*
     * WARNING - void declaration
     */
    public synchronized boolean execute(S sender, String ... inputs) {
        try {
            this.input = String.join((CharSequence)" ", inputs);
            MagicList list = new MagicList(this.tree.entrySet());
            MagicMap<Map.Entry, ArgumentEntry.Result> map = new MagicMap<Map.Entry, ArgumentEntry.Result>();
            for (Map.Entry entry : list) {
                ArgumentEntry.Result result = ((ArgumentEntry)entry.getKey()).matchesEntry(this.input);
                if (result == ArgumentEntry.Result.FALSE) continue;
                map.put(entry, result);
            }
            if (!map.isEmpty()) {
                void var6_10;
                ArgumentEntry entry;
                MagicMap perfect = new MagicMap(map);
                perfect.entrySet().removeIf(e -> e.getValue() == ArgumentEntry.Result.TRAILING);
                if (perfect.isEmpty()) {
                    entry = (ArgumentEntry)((Map.Entry)map.getFirst().getKey()).getKey();
                    CommandAction commandAction = (CommandAction)((Map.Entry)map.getFirst().getKey()).getValue();
                } else {
                    entry = (ArgumentEntry)((Map.Entry)perfect.getFirst().getKey()).getKey();
                    CommandAction commandAction = (CommandAction)((Map.Entry)perfect.getFirst().getKey()).getValue();
                }
                if (var6_10 instanceof CommandSingleAction) {
                    var6_10.accept(sender);
                } else {
                    var6_10.accept(sender, entry.compileEntry(this.input));
                }
            } else {
                this.getDefault().accept(sender);
            }
            return true;
        }
        catch (Throwable throwable) {
            if (this.error != null) {
                return this.error.apply(sender, throwable);
            }
            System.out.println("Command Error in '" + this.getCommand() + "' - " + throwable.getMessage());
            return false;
        }
    }

    public MagicList<String> getTabCompletions(String input) {
        String[] inputs = input.split(" ");
        return this.getTabCompletions(inputs);
    }

    public MagicList<String> getTabCompletions(String ... inputs) {
        MagicList<String> list = new MagicList<String>();
        for (ArgumentEntry arguments : this.tree.keySet()) {
            for (String completion : arguments.getCompletions(inputs.length, inputs)) {
                if (list.contains(completion)) continue;
                list.add(completion);
            }
        }
        return list;
    }

    @NotNull
    public Collection<String> getPatterns() {
        return new ArrayList<String>(this.patterns);
    }

    @NotNull
    public @NotNull Map<@NotNull String, @Nullable String> getPatternDescriptions() {
        return new HashMap<String, String>(this.patternDescriptions);
    }

    @NotNull
    private @NotNull Map<@NotNull String, @Nullable String> getPatternDesc() {
        MagicMap<@NotNull String, @Nullable String> map = new MagicMap<String, String>();
        for (ArgumentEntry entry : this.tree.keySet()) {
            map.put(entry.args, entry.description);
        }
        return map;
    }

    public MagicList<String> getPossibleArguments(String ... inputs) {
        if (inputs.length == 0) {
            return new MagicList(this.tree.keySet()).collect(entry -> entry.args);
        }
        String input = String.join((CharSequence)" ", inputs);
        MagicList list = new MagicList(this.tree.keySet());
        list.removeIf(entry -> !entry.matches(input));
        return list.collect(entry -> entry.args);
    }

    public String getInput() {
        return this.input;
    }

    protected CommandImpl command(String namespace, String ... aliases) {
        this.namespace = namespace;
        this.aliases.addAll((String[])aliases);
        return new CommandImpl();
    }

    public abstract CommandSingleAction<S> getDefault();

    public Description desc(@Nullable String string) {
        return string != null ? new Description(string) : null;
    }

    public SubArg arg(String arg, CommandSingleAction<S> action) {
        return new SubArg(new ArgLiteral(arg), action);
    }

    public SubArg arg(String arg, Description description, CommandSingleAction<S> action) {
        SubArg subArg = new SubArg(new ArgLiteral(arg), action);
        subArg.description = description;
        return subArg;
    }

    @SafeVarargs
    public final SubArg arg(String arg, SubArg ... args) {
        return new SubArg((Argument<?>)new ArgLiteral(arg), null, args);
    }

    @SafeVarargs
    public final SubArg arg(String @NotNull [] arg, SubArg ... args) {
        return new SubArg((Argument<?>)new ArgLiteralPlural(arg), null, args);
    }

    @SafeVarargs
    public final SubArg arg(String @NotNull [] arg, CommandSingleAction<S> action, SubArg ... args) {
        return new SubArg(new ArgLiteralPlural(arg), action, args);
    }

    @SafeVarargs
    public final SubArg arg(String @NotNull [] arg, Description description, CommandSingleAction<S> action, SubArg ... args) {
        SubArg subArg = new SubArg(new ArgLiteralPlural(arg), action, args);
        subArg.description = description;
        return subArg;
    }

    @SafeVarargs
    public final SubArg arg(String arg, CommandSingleAction<S> action, SubArg ... args) {
        return new SubArg(new ArgLiteral(arg), action, args);
    }

    @SafeVarargs
    public final SubArg arg(String arg, Description description, CommandSingleAction<S> action, SubArg ... args) {
        SubArg subArg = new SubArg(new ArgLiteral(arg), action, args);
        subArg.description = description;
        return subArg;
    }

    public SubArg arg(CommandSingleAction<S> action, String ... arg) {
        return new SubArg(new ArgLiteralPlural(arg), action);
    }

    public SubArg arg(CommandSingleAction<S> action, Description description, String ... arg) {
        SubArg subArg = new SubArg(new ArgLiteralPlural(arg), action);
        subArg.description = description;
        return subArg;
    }

    public SubArg arg(CommandBiAction<S> action, Argument<?> ... arguments) {
        return this.arg(null, action, arguments);
    }

    public SubArg arg(Description description, CommandBiAction<S> action, Argument<?> ... arguments) {
        if (arguments.length == 0) {
            throw new IllegalArgumentException("No arguments were provided!");
        }
        SubArg top = null;
        SubArg arg = null;
        for (Argument<?> argument : arguments) {
            SubArg current = new SubArg(argument, (CommandAction)null);
            if (top == null) {
                top = current;
            }
            if (arg != null) {
                arg.children.add(current);
            }
            arg = current;
        }
        arg.action = action;
        arg.description = description;
        return top;
    }

    @NotNull
    public String getCommand() {
        return this.namespace;
    }

    @NotNull
    public List<String> getAliases() {
        return this.aliases;
    }

    static class ArgumentEntry
    extends MagicList<Argument<?>> {
        final Pattern pattern;
        final String args;
        String description;

        public ArgumentEntry(Argument<?> ... arguments) {
            super(arguments);
            StringBuilder builder = new StringBuilder();
            MagicList strings = new MagicList();
            for (Argument argument : this) {
                builder.append(argument.getPattern().toString().replace("^", "").replace("$", "")).append(" ");
                if (argument.isLiteral()) {
                    strings.add(argument.getName());
                    continue;
                }
                strings.add((argument.isRequired() ? "<" : "[") + (argument.isPlural() ? "*" : "") + argument.getName() + (argument.isFinal() ? "..." : "") + (argument.isRequired() ? ">" : "]"));
            }
            this.pattern = Pattern.compile("^" + builder.toString().trim());
            this.args = String.join((CharSequence)" ", strings);
        }

        public ArgumentEntry(Collection<Argument<?>> arguments) {
            super(arguments);
            StringBuilder builder = new StringBuilder();
            MagicList strings = new MagicList();
            for (Argument argument : this) {
                builder.append(argument.getPattern().toString().replace("^", "").replace("$", "")).append(" ");
                if (argument.isLiteral()) {
                    strings.add(argument.getName());
                    continue;
                }
                strings.add((argument.isRequired() ? "<" : "[") + (argument.isPlural() ? "*" : "") + argument.getName() + (argument.isFinal() ? "..." : "") + (argument.isRequired() ? ">" : "]"));
            }
            this.pattern = Pattern.compile("^" + builder.toString().trim());
            this.args = String.join((CharSequence)" ", strings);
        }

        Pattern getPattern() {
            return this.pattern;
        }

        boolean matches(String input) {
            Matcher matcher = this.pattern.matcher(input.trim());
            return matcher.matches();
        }

        boolean inputMatches(String[] inputs) {
            StringBuilder builder = new StringBuilder();
            int i = 1;
            for (Argument argument : this) {
                if (++i == inputs.length) break;
                if (argument instanceof ArgLiteralPlural) {
                    builder.append("(").append(String.join((CharSequence)"|", ((ArgLiteralPlural)argument).aliases)).append(")").append(" ");
                    continue;
                }
                if (argument instanceof ArgLiteral) {
                    builder.append(argument.getName()).append(" ");
                    continue;
                }
                if (argument.isRequired()) {
                    if (argument.isFinal()) {
                        builder.append("(.+)").append(" ");
                        continue;
                    }
                    builder.append("(\\S+)").append(" ");
                    continue;
                }
                if (argument.isFinal()) {
                    builder.append("(.*)").append(" ");
                    continue;
                }
                builder.append("(\\S*)").append(" ?");
            }
            Pattern pattern = Pattern.compile("^" + builder.toString().toLowerCase().trim() + ".*");
            return pattern.matcher(String.join((CharSequence)" ", inputs).toLowerCase().trim()).matches();
        }

        public Result matchesEntry(String input) {
            StringReader reader = new StringReader(input);
            for (Argument argument : this) {
                String segment = argument.isFinal() ? reader.readRest() : (argument.acceptSpaces() ? reader.readUntilMatchesAfter(argument.getPattern(), ' ') : reader.readUntil(' '));
                if (argument.isRequired()) {
                    if (!argument.getPattern().matcher(segment).matches()) {
                        return Result.FALSE;
                    }
                    if (!argument.matches(segment)) {
                        return Result.FALSE;
                    }
                }
                reader.skip();
            }
            return reader.readRest().trim().isEmpty() ? Result.TRUE : Result.TRAILING;
        }

        public Object[] compileEntry(String input) {
            MagicList<Object> objects = new MagicList<Object>();
            StringReader reader = new StringReader(input);
            for (Argument argument : this) {
                String segment = argument.isFinal() ? reader.readRest() : (argument.acceptSpaces() ? reader.readUntilMatchesAfter(argument.getPattern(), ' ') : reader.readUntil(' '));
                if (!argument.isLiteral()) {
                    objects.add(argument.serialise(segment));
                }
                reader.skip();
            }
            return objects.toArray(new Object[0]);
        }

        Collection<String> getCompletions(int position, String[] inputs) {
            List<String> strings;
            ArrayList<String> list = new ArrayList<String>();
            if (position < 2) {
                List<String> strings2 = ((Argument)this.get(0)).getCompletions();
                if (strings2 != null) {
                    list.addAll(strings2);
                }
            } else if (this.size() > position - 1 && this.inputMatches(inputs) && (strings = ((Argument)this.get(position - 1)).getCompletions()) != null) {
                list.addAll(strings);
            }
            return list;
        }

        public static enum Result {
            FALSE,
            TRAILING,
            TRUE;

        }
    }

    class ArgumentTree
    extends MagicMap<ArgumentEntry, CommandAction<S>> {
        ArgumentTree() {
        }
    }

    private static class Description {
        @Nullable
        protected final String string;

        public Description(@Nullable String string) {
            this.string = string;
        }
    }

    @FunctionalInterface
    public static interface CommandBiAction<S>
    extends CommandAction<S> {
        @Override
        public void accept(S var1, Object[] var2);

        @Override
        default public void accept(S sender) {
            this.accept(sender, new Object[0]);
        }

        @Override
        default public boolean isSingle() {
            return false;
        }
    }

    @FunctionalInterface
    public static interface CommandSingleAction<S>
    extends CommandAction<S> {
        @Override
        public void accept(S var1);

        @Override
        default public void accept(S sender, Object[] object) {
            this.accept(sender);
        }

        @Override
        default public boolean isSingle() {
            return true;
        }
    }

    static interface CommandAction<S> {
        default public void execute(S sender, Object[] object) {
            if (this.isSingle()) {
                this.accept(sender);
            } else {
                this.accept(sender, object);
            }
        }

        public void accept(S var1);

        public void accept(S var1, Object[] var2);

        public boolean isSingle();
    }

    public class SubArg {
        public final Argument<?> argument;
        public CommandAction<S> action;
        public final MagicList<SubArg> children = new MagicList();
        public Description description = null;

        public SubArg(Argument<?> argument, CommandAction<S> action) {
            this.argument = argument;
            this.action = action;
        }

        public SubArg(Argument<?> argument, Description description, CommandAction<S> action) {
            this.argument = argument;
            this.action = action;
            this.description = description;
        }

        @SafeVarargs
        public SubArg(Argument<?> argument, CommandAction<S> action, SubArg ... children) {
            this.argument = argument;
            this.action = action;
            this.children.addAll((SubArg[])children);
        }

        @SafeVarargs
        public SubArg(Argument<?> argument, Description description, CommandAction<S> action, SubArg ... children) {
            this.argument = argument;
            this.action = action;
            this.description = description;
            this.children.addAll((SubArg[])children);
        }

        @SafeVarargs
        public SubArg(Argument<?> argument, SubArg ... children) {
            this.argument = argument;
            this.action = null;
            this.children.addAll((SubArg[])children);
        }

        public void compile(MagicList<Argument<?>> list) {
            list.add(this.argument);
            if (this.action != null) {
                ArgumentEntry entry = new ArgumentEntry((Collection<Argument<?>>)list);
                if (this.description != null) {
                    entry.description = this.description.string;
                }
                Commander.this.tree.put(entry, this.action);
            }
            if (!this.children.isEmpty()) {
                for (SubArg child : this.children) {
                    child.compile(new MagicList((Collection<Argument<?>>)list));
                }
            }
        }
    }

    public class CommandImpl {
        private CommandImpl() {
        }

        public CommandImpl arg(String arg, CommandSingleAction<S> action) {
            return this.arg(arg, null, action);
        }

        public CommandImpl arg(String arg, Description description, CommandSingleAction<S> action) {
            ArgumentEntry entry = new ArgumentEntry(new Argument[]{new ArgLiteral(arg)});
            if (description != null) {
                entry.description = description.string;
            }
            Commander.this.tree.put(entry, action);
            return this;
        }

        public CommandImpl arg(CommandSingleAction<S> action, String arg) {
            return this.arg(action, arg, (Description)null);
        }

        public CommandImpl arg(CommandSingleAction<S> action, String arg, Description description) {
            ArgumentEntry entry = new ArgumentEntry(new Argument[]{new ArgLiteral(arg)});
            if (description != null) {
                entry.description = description.string;
            }
            Commander.this.tree.put(entry, action);
            return this;
        }

        public CommandImpl arg(CommandSingleAction<S> action, String ... arg) {
            ArgumentEntry entry = new ArgumentEntry(new Argument[]{new ArgLiteralPlural(arg)});
            Commander.this.tree.put(entry, action);
            return this;
        }

        public CommandImpl arg(CommandSingleAction<S> action, Description description, String ... arg) {
            ArgumentEntry entry = new ArgumentEntry(new Argument[]{new ArgLiteralPlural(arg)});
            if (description != null) {
                entry.description = description.string;
            }
            Commander.this.tree.put(entry, action);
            return this;
        }

        @SafeVarargs
        public final CommandImpl arg(String @NotNull [] arg, SubArg ... subArguments) {
            MagicList list = new MagicList(new ArgLiteralPlural(arg));
            for (SubArg subArg : subArguments) {
                subArg.compile(list);
            }
            return this;
        }

        @SafeVarargs
        public final CommandImpl arg(String arg, SubArg ... subArguments) {
            MagicList list = new MagicList(new ArgLiteral(arg));
            for (SubArg subArg : subArguments) {
                subArg.compile(list);
            }
            return this;
        }

        @SafeVarargs
        public final CommandImpl arg(String arg, CommandSingleAction<S> action, SubArg ... subArguments) {
            return this.arg(arg, null, action, subArguments);
        }

        @SafeVarargs
        public final CommandImpl arg(String arg, Description description, CommandSingleAction<S> action, SubArg ... subArguments) {
            ArgumentEntry entry = new ArgumentEntry(new Argument[]{new ArgLiteral(arg)});
            if (description != null) {
                entry.description = description.string;
            }
            Commander.this.tree.put(entry, action);
            MagicList list = new MagicList(new ArgLiteral(arg));
            for (SubArg subArg : subArguments) {
                subArg.compile(list);
            }
            return this;
        }

        @SafeVarargs
        public final CommandImpl arg(CommandSingleAction<S> action, String arg, SubArg ... subArguments) {
            ArgumentEntry entry = new ArgumentEntry(new Argument[]{new ArgLiteral(arg)});
            Commander.this.tree.put(entry, action);
            MagicList list = new MagicList(new ArgLiteral(arg));
            for (SubArg subArg : subArguments) {
                subArg.compile(list);
            }
            return this;
        }

        @SafeVarargs
        public final CommandImpl arg(CommandSingleAction<S> action, String arg, Description description, SubArg ... subArguments) {
            return this.arg(arg, description, action, subArguments);
        }

        @SafeVarargs
        public final CommandImpl arg(CommandSingleAction<S> action, String @NotNull [] arg, SubArg ... subArguments) {
            return this.arg(action, arg, (Description)null, subArguments);
        }

        @SafeVarargs
        public final CommandImpl arg(CommandSingleAction<S> action, String @NotNull [] arg, Description description, SubArg ... subArguments) {
            ArgumentEntry entry = new ArgumentEntry(new Argument[]{new ArgLiteralPlural(arg)});
            if (description != null) {
                entry.description = description.string;
            }
            Commander.this.tree.put(entry, action);
            MagicList list = new MagicList(new ArgLiteralPlural(arg));
            for (SubArg subArg : subArguments) {
                subArg.compile(list);
            }
            return this;
        }

        public final CommandImpl arg(CommandBiAction<S> action, Argument<?> ... arguments) {
            return this.arg(null, action, arguments);
        }

        public final CommandImpl arg(Description description, CommandBiAction<S> action, Argument<?> ... arguments) {
            if (arguments.length == 0) {
                return this;
            }
            SubArg top = null;
            SubArg arg = null;
            for (Argument<?> argument : arguments) {
                SubArg current = new SubArg(argument, (CommandAction)null);
                if (top == null) {
                    top = current;
                }
                if (arg != null) {
                    arg.children.add(current);
                }
                arg = current;
            }
            arg.action = action;
            if (description != null) {
                arg.description = description;
            }
            top.compile(new MagicList());
            return this;
        }

        public CommandImpl arg(Argument<?> argument, CommandBiAction<S> action) {
            return this.arg(null, argument, action);
        }

        public CommandImpl arg(Description description, Argument<?> argument, CommandBiAction<S> action) {
            SubArg top = new SubArg(argument, action);
            top.description = description;
            top.compile(new MagicList());
            return this;
        }

        public final CommandImpl onException(@Nullable BiFunction<S, Throwable, Boolean> errorFunction) {
            Commander.this.error = errorFunction;
            return this;
        }
    }
}

