/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.mask.command;

import com.moderocky.guardian.mask.api.MagicList;
import com.moderocky.guardian.mask.api.MagicMap;
import com.moderocky.guardian.mask.api.MagicStringList;
import com.moderocky.guardian.mask.command.ArgLiteral;
import com.moderocky.guardian.mask.command.Argument;
import com.moderocky.guardian.mask.command.Commander;
import com.moderocky.guardian.mask.command.IllegalCommandException;
import com.moderocky.guardian.mask.command.annotation.Arguments;
import com.moderocky.guardian.mask.command.annotation.Command;
import com.moderocky.guardian.mask.command.annotation.Default;
import com.moderocky.guardian.mask.command.annotation.Description;
import com.moderocky.guardian.mask.command.annotation.Permission;
import com.moderocky.guardian.mask.command.annotation.Usage;
import com.moderocky.guardian.mask.mirror.MethodMirror;
import com.moderocky.guardian.mask.mirror.Mirror;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BukkitCommand
implements CommandExecutor,
TabCompleter {
    private final Commander.CommandSingleAction<CommandSender> defaultAction;
    private final MagicMap<Commander.ArgumentEntry, Commander.CommandAction<CommandSender>> argumentMap = new MagicMap();
    private final Commander<CommandSender> commander;
    private String[] command;
    private String description;
    private String permission;
    private String permissionMessage;
    private String usage;

    public BukkitCommand() {
        Mirror<BukkitCommand> mirror = new Mirror<BukkitCommand>(this);
        if (!mirror.hasAnnotation(Command.class)) {
            throw new IllegalCommandException("No command annotations were provided!");
        }
        MethodMirror<?>[] mirrors = mirror.getMethodMirrors(Default.class);
        if (mirrors.length < 1) {
            throw new IllegalCommandException("No default behaviour was provided!");
        }
        MethodMirror<?> method = mirrors[0];
        if (method.getParameterCount() != 1) {
            throw new IllegalCommandException("Default method should accept only a command sender!");
        }
        this.defaultAction = xva$0 -> method.invoke(xva$0);
        for (MethodMirror<?> methodMirror : mirrors = mirror.getMethodMirrors(Arguments.class)) {
            Commander.CommandBiAction<CommandSender> action;
            Arguments arguments = methodMirror.getAnnotation(Arguments.class);
            new Commander.ArgumentEntry(new Argument[0]);
            MagicList<Argument> args = new MagicList<Argument>();
            for (String string : arguments.literal()) {
                args.add(new ArgLiteral(string));
            }
            for (Class<? extends Argument<?>> cls : arguments.value()) {
                try {
                    args.add(cls.newInstance());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            Commander.ArgumentEntry entry = new Commander.ArgumentEntry(args.toArray(new Argument[0]));
            if (methodMirror.hasAnnotation(Permission.class)) {
                String permission = methodMirror.getAnnotation(Permission.class).value();
                action = (sender, input) -> {
                    if (sender.hasPermission(permission)) {
                        MagicList<Object> objects = new MagicList<Object>();
                        objects.add(sender);
                        objects.addAll(input);
                        methodMirror.invoke(objects.toArray(new Object[0]));
                    } else if (this.permissionMessage != null && !this.permissionMessage.isEmpty()) {
                        sender.sendMessage(this.permissionMessage);
                    } else {
                        PluginCommand c = Bukkit.getServer().getPluginCommand(this.command[0]);
                        if (c != null && c.getPermissionMessage() != null) {
                            sender.sendMessage(c.getPermissionMessage());
                        }
                    }
                };
            } else {
                action = (sender, input) -> {
                    MagicList<Object> objects = new MagicList<Object>();
                    objects.add(sender);
                    objects.addAll(input);
                    methodMirror.invoke(objects.toArray(new Object[0]));
                };
            }
            this.argumentMap.put(entry, action);
        }
        this.commander = new Commander<CommandSender>(mirror){
            final /* synthetic */ Mirror val$mirror;
            {
                this.val$mirror = mirror;
                this.tree.putAll(BukkitCommand.this.argumentMap);
                this.compile();
            }

            @Override
            protected Commander.CommandImpl create() {
                Command command = this.val$mirror.getAnnotation(Command.class);
                MagicStringList list = new MagicStringList(command.value());
                return this.command((String)list.remove(0), list.toArray());
            }

            @Override
            public Commander.CommandSingleAction<CommandSender> getDefault() {
                return BukkitCommand.this.defaultAction;
            }
        };
        mirror.ifHasAnnotation(Command.class, note -> {
            this.command = note.value();
        });
        mirror.ifHasAnnotation(Description.class, note -> {
            this.description = note.value();
        });
        mirror.ifHasAnnotation(Usage.class, note -> {
            this.usage = note.value();
        });
        mirror.ifHasAnnotation(Permission.class, note -> {
            this.permission = note.value();
            this.permissionMessage = note.message();
        });
    }

    public BukkitCommand(Plugin plugin) {
        Mirror<BukkitCommand> mirror = new Mirror<BukkitCommand>(this);
        if (!mirror.hasAnnotation(Command.class)) {
            throw new IllegalCommandException("No command annotations were provided!");
        }
        MethodMirror<?>[] mirrors = mirror.getMethodMirrors(Default.class);
        if (mirrors.length < 1) {
            throw new IllegalCommandException("No default behaviour was provided!");
        }
        MethodMirror<?> method = mirrors[0];
        if (method.getParameterCount() != 1) {
            throw new IllegalCommandException("Default method should accept only a command sender!");
        }
        this.defaultAction = xva$0 -> method.invoke(xva$0);
        for (MethodMirror<?> methodMirror : mirrors = mirror.getMethodMirrors(Arguments.class)) {
            Commander.CommandBiAction<CommandSender> action;
            Arguments arguments = methodMirror.getAnnotation(Arguments.class);
            new Commander.ArgumentEntry(new Argument[0]);
            MagicList<Argument> args = new MagicList<Argument>();
            for (String string : arguments.literal()) {
                args.add(new ArgLiteral(string));
            }
            for (Class<? extends Argument<?>> cls : arguments.value()) {
                try {
                    args.add(cls.newInstance());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            Commander.ArgumentEntry entry = new Commander.ArgumentEntry(args.toArray(new Argument[0]));
            if (methodMirror.hasAnnotation(Permission.class)) {
                String permission = methodMirror.getAnnotation(Permission.class).value();
                action = (sender, input) -> {
                    if (sender.hasPermission(permission)) {
                        MagicList<Object> objects = new MagicList<Object>();
                        objects.add(sender);
                        objects.addAll(input);
                        methodMirror.invoke(objects.toArray(new Object[0]));
                    } else if (this.permissionMessage != null && !this.permissionMessage.isEmpty()) {
                        sender.sendMessage(this.permissionMessage);
                    } else {
                        PluginCommand c = Bukkit.getServer().getPluginCommand(this.command[0]);
                        if (c != null && c.getPermissionMessage() != null) {
                            sender.sendMessage(c.getPermissionMessage());
                        }
                    }
                };
            } else {
                action = (sender, input) -> {
                    MagicList<Object> objects = new MagicList<Object>();
                    objects.add(sender);
                    objects.addAll(input);
                    methodMirror.invoke(objects.toArray(new Object[0]));
                };
            }
            this.argumentMap.put(entry, action);
        }
        this.commander = new /* invalid duplicate definition of identical inner class */;
        mirror.ifHasAnnotation(Command.class, note -> {
            this.command = note.value();
        });
        mirror.ifHasAnnotation(Description.class, note -> {
            this.description = note.value();
        });
        mirror.ifHasAnnotation(Usage.class, note -> {
            this.usage = note.value();
        });
        mirror.ifHasAnnotation(Permission.class, note -> {
            this.permission = note.value();
            this.permissionMessage = note.message();
        });
        this.register(plugin);
    }

    public final synchronized void register(Plugin plugin) {
        CommandMap commandMap = (CommandMap)new Mirror<Server>(Bukkit.getServer()).field("commandMap").get();
        try {
            Constructor commandConstructor = PluginCommand.class.getDeclaredConstructor(String.class, Plugin.class);
            if (!commandConstructor.isAccessible()) {
                commandConstructor.setAccessible(true);
            }
            PluginCommand pluginCommand = (PluginCommand)commandConstructor.newInstance(this.commander.getCommand(), plugin);
            pluginCommand.setAliases(this.commander.getAliases());
            pluginCommand.setDescription(this.description);
            pluginCommand.setPermission(this.permission);
            pluginCommand.setPermissionMessage(this.permissionMessage == null ? null : (this.permissionMessage.isEmpty() ? null : this.permissionMessage));
            pluginCommand.setUsage(this.usage);
            pluginCommand.register(commandMap);
            if (commandMap.register(this.commander.getCommand(), plugin.getName(), (org.bukkit.command.Command)pluginCommand)) {
                pluginCommand.setExecutor((CommandExecutor)this);
                pluginCommand.setTabCompleter((TabCompleter)this);
            } else {
                org.bukkit.command.Command com = commandMap.getCommand(pluginCommand.getName());
                if (com instanceof PluginCommand) {
                    ((PluginCommand)com).setExecutor((CommandExecutor)this);
                    ((PluginCommand)com).setTabCompleter((TabCompleter)this);
                }
                Bukkit.getLogger().log(Level.WARNING, "A command '/" + this.commander.getCommand() + "' is already defined!");
                Bukkit.getLogger().log(Level.WARNING, "As this cannot be replaced, the executor will be overridden.");
                Bukkit.getLogger().log(Level.WARNING, "To avoid this warning, please do not add WrappedCommands to your plugin.yml.");
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public boolean onCommand(@NotNull CommandSender commandSender, @NotNull org.bukkit.command.Command command, @NotNull String s, @NotNull String[] strings) {
        return this.commander.execute(commandSender, strings);
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull org.bukkit.command.Command command, @NotNull String s, @NotNull String[] strings) {
        return this.commander.getTabCompletions(strings);
    }
}

