/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.mask.command;

import com.moderocky.guardian.mask.command.Argument;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArgPlayer
implements Argument<Player> {
    private String label = "player";
    private boolean required = true;

    @Override
    @NotNull
    public Player serialise(String string) {
        Player player = Bukkit.getPlayer((String)string);
        if (player == null) {
            throw new IllegalArgumentException();
        }
        return player;
    }

    @Override
    public boolean matches(String string) {
        return Bukkit.getPlayer((String)string) != null;
    }

    @Override
    @NotNull
    public String getName() {
        return this.label;
    }

    @Override
    @Nullable
    public List<String> getCompletions() {
        ArrayList<String> players = new ArrayList<String>();
        Bukkit.getOnlinePlayers().forEach(player -> players.add(player.getName()));
        return players;
    }

    @Override
    public boolean isPlural() {
        return false;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    public ArgPlayer setRequired(boolean boo) {
        this.required = boo;
        return this;
    }

    public ArgPlayer setLabel(@NotNull String label) {
        this.label = label;
        return this;
    }

    @Override
    public Pattern getPattern() {
        return Pattern.compile("^(\\S+)$");
    }
}

