/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.mask.command;

import com.moderocky.guardian.mask.command.Argument;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArgOfflinePlayer
implements Argument<OfflinePlayer> {
    private String label = "player/uuid";
    private boolean required = true;

    @Override
    @NotNull
    public OfflinePlayer serialise(String string) {
        Player player = Bukkit.getPlayer((String)string);
        if (player == null) {
            return Bukkit.getOfflinePlayer((UUID)UUID.fromString(string));
        }
        return player;
    }

    @Override
    public boolean matches(String string) {
        if (Bukkit.getPlayer((String)string) != null) {
            return true;
        }
        try {
            UUID uuid = UUID.fromString(string);
            Bukkit.getOfflinePlayer((UUID)uuid);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    @Override
    @NotNull
    public String getName() {
        return this.label;
    }

    @Override
    @Nullable
    public List<String> getCompletions() {
        ArrayList<String> players = new ArrayList<String>();
        Bukkit.getOnlinePlayers().forEach(player -> players.add(player.getName()));
        return players;
    }

    @Override
    public boolean isPlural() {
        return false;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    public ArgOfflinePlayer setRequired(boolean boo) {
        this.required = boo;
        return this;
    }

    public ArgOfflinePlayer setLabel(@NotNull String label) {
        this.label = label;
        return this;
    }

    @Override
    public Pattern getPattern() {
        return Pattern.compile("^(\\S+)$");
    }
}

