/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.mask.command;

import com.moderocky.guardian.mask.api.MagicStringList;
import com.moderocky.guardian.mask.command.Argument;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArgBoolean
implements Argument<Boolean> {
    private static final Pattern pattern = Pattern.compile("^(yes|y|no|n|true|false|1|0)$");
    private String label = "boolean";
    private boolean required = true;
    private final MagicStringList ayes = new MagicStringList("yes", "1", "true", "y");
    private final MagicStringList noes = new MagicStringList("no", "0", "false", "n");

    @Override
    @NotNull
    public Boolean serialise(String string) {
        return this.ayes.containsIgnoreCase(string);
    }

    @Override
    public boolean matches(String string) {
        return this.ayes.containsIgnoreCase(string) || this.noes.containsIgnoreCase(string);
    }

    @Override
    @NotNull
    public String getName() {
        return this.label;
    }

    @Override
    @Nullable
    public List<String> getCompletions() {
        return new MagicStringList("true", "false");
    }

    @Override
    public boolean isPlural() {
        return false;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    public ArgBoolean setRequired(boolean boo) {
        this.required = boo;
        return this;
    }

    public ArgBoolean setLabel(@NotNull String label) {
        this.label = label;
        return this;
    }

    @Override
    public Pattern getPattern() {
        return pattern;
    }
}

