/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.mask.api.web;

import com.moderocky.guardian.mask.annotation.DoNotInstantiate;
import com.moderocky.guardian.mask.annotation.Internal;
import com.moderocky.guardian.mask.annotation.Unsafe;
import com.moderocky.guardian.mask.api.web.WebServer;
import com.moderocky.guardian.mask.api.web.event.GetEvent;
import com.moderocky.guardian.mask.api.web.event.HeadEvent;
import com.moderocky.guardian.mask.api.web.event.JSQEvent;
import com.moderocky.guardian.mask.api.web.event.PostEvent;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import org.bukkit.Bukkit;

@Internal
public abstract class WebConnection
extends Thread
implements Runnable {
    private final File webRoot;
    private final String defaultFile;
    private final String fileNotFound;
    private final String methodNotSupported;
    private final boolean debug;
    private final Socket connector;
    private final WebServer<? extends WebConnection> server;

    @Internal
    @DoNotInstantiate
    public WebConnection(Socket socket, WebServer<? extends WebConnection> webServer) {
        this.connector = socket;
        this.server = webServer;
        this.webRoot = this.server.getWebRootFolder();
        this.defaultFile = this.server.getDefaultFileName();
        this.fileNotFound = this.server.get404();
        this.methodNotSupported = this.server.getMethodNotSupportedFileName();
        this.debug = this.server.isDebug();
    }

    public boolean isDebug() {
        return this.debug;
    }

    public Socket getConnector() {
        return this.connector;
    }

    public WebServer<? extends WebConnection> getServer() {
        return this.server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Internal
    @Unsafe
    public void run() {
        this.server.addConnection(this);
        BufferedReader reader = null;
        PrintWriter writer = null;
        FilterOutputStream outputStream = null;
        String fileRequested = null;
        try {
            String ln;
            InputStream stream = this.connector.getInputStream();
            reader = new BufferedReader(new InputStreamReader(stream));
            writer = new PrintWriter(this.connector.getOutputStream());
            outputStream = new BufferedOutputStream(this.connector.getOutputStream());
            reader.mark(stream.available());
            ArrayList<String> lines = new ArrayList<String>();
            for (int i = 0; i < 100 && reader.ready() && (ln = reader.readLine()) != null; ++i) {
                lines.add(ln);
                if (!reader.ready()) break;
            }
            if (lines.size() > 0) {
                String input = (String)lines.get(0);
                StringTokenizer parse = new StringTokenizer(input);
                String method = parse.nextToken().toUpperCase();
                fileRequested = parse.nextToken().toLowerCase();
                if (!(method.equals("GET") || method.equals("HEAD") || method.equals("POST") || method.equals("JSQ"))) {
                    if (this.debug) {
                        Bukkit.getLogger().info("501 Not Implemented: " + method + " method.");
                    }
                    File file = new File(this.webRoot, this.methodNotSupported);
                    int fileLength = (int)file.length();
                    String contentMimeType = "text/html";
                    byte[] fileData = this.readFileData(file, fileLength);
                    writer.println("HTTP/1.1 501 Not Implemented");
                    this.outPrinter(writer, outputStream, fileLength, contentMimeType, fileData);
                } else {
                    GetEvent event;
                    if (fileRequested.endsWith("/") || fileRequested.endsWith("/?")) {
                        fileRequested = fileRequested + this.defaultFile;
                    }
                    File file = new File(this.webRoot, fileRequested);
                    int fileLength = (int)file.length();
                    String content = this.getContentType(fileRequested);
                    if (method.equals("GET") && !(event = this.server.callEvent(new GetEvent(this.server, this, this.connector, (BufferedOutputStream)outputStream, reader, writer, fileRequested))).isCancelled()) {
                        byte[] fileData = this.readFileData(file, fileLength);
                        writer.println("HTTP/1.1 200 OK");
                        this.outPrinter(writer, outputStream, fileLength, content, fileData);
                    }
                    if (method.equals("POST")) {
                        PostEvent postEvent = this.server.callEvent(new PostEvent(this.server, this, this.connector, (BufferedOutputStream)outputStream, reader, writer, fileRequested));
                    }
                    if (method.equals("HEAD")) {
                        this.server.callEvent(new HeadEvent(this.server, this, this.connector, (BufferedOutputStream)outputStream, reader, writer, fileRequested));
                    }
                    if (method.equals("JSQ")) {
                        this.server.callEvent(new JSQEvent(this.server, this, this.connector, (BufferedOutputStream)outputStream, reader, writer, fileRequested));
                    }
                    if (this.debug) {
                        Bukkit.getLogger().info("File " + fileRequested + " of type " + content + " returned.");
                    }
                }
            }
        }
        catch (FileNotFoundException fnfe) {
            try {
                if (writer != null && outputStream != null) {
                    this.fileNotFound(writer, outputStream, fileRequested);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        catch (IOException e) {
            if (this.debug) {
                Bukkit.getLogger().info("Connection file error.");
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (writer != null) {
                    writer.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
                this.connector.close();
            }
            catch (Exception fnfe) {}
            if (this.debug) {
                Bukkit.getLogger().info("Connection closed.");
            }
            this.server.removeConnection(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Internal
    public byte[] readFileData(File file, int fileLength) throws IOException {
        byte[] fileData = new byte[fileLength];
        try (FileInputStream fileIn = null;){
            fileIn = new FileInputStream(file);
            fileIn.read(fileData);
        }
        return fileData;
    }

    @Internal
    public String getContentType(String fileRequested) {
        if (fileRequested.endsWith(".htm") || fileRequested.endsWith(".html") || fileRequested.endsWith(".xml") || fileRequested.endsWith(".xhtml") || fileRequested.endsWith(".php")) {
            return "text/html";
        }
        return "text/plain";
    }

    @Internal
    public void fileNotFound(PrintWriter out, OutputStream dataOut, String fileRequested) throws IOException {
        File file = new File(this.webRoot, this.fileNotFound);
        int fileLength = (int)file.length();
        String content = "text/html";
        byte[] fileData = this.readFileData(file, fileLength);
        out.println("HTTP/1.1 404 File Not Found");
        this.outPrinter(out, dataOut, fileLength, content, fileData);
        if (this.debug) {
            Bukkit.getLogger().info("File " + fileRequested + " not found.");
        }
    }

    @Internal
    public void outPrinter(PrintWriter out, OutputStream dataOut, int fileLength, String content, byte[] fileData) throws IOException {
        out.println("Date: " + new Date());
        out.println("Content-type: " + content);
        out.println("Content-length: " + fileLength);
        out.println();
        out.flush();
        dataOut.write(fileData, 0, fileLength);
        dataOut.flush();
    }
}

