/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.mask.api.container;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PositionalMap<X> {
    @NotNull
    private final Comparator<Coords> comparator = (o1, o2) -> {
        int d = o1.y - o2.y;
        if (d == 0) {
            d = o1.x - o2.y;
        }
        return d;
    };
    @NotNull
    private final TreeMap<Coords, X> map = new TreeMap(this.comparator);

    @Nullable
    public X get(int x, int y) {
        Coords coords = new Coords(x, y);
        return this.map.get(coords);
    }

    public X getOrDefault(int x, int y, X def) {
        Coords coords = new Coords(x, y);
        return this.map.getOrDefault(coords, def);
    }

    public boolean containsEntry(int x, int y) {
        Coords coords = new Coords(x, y);
        return this.map.containsKey(coords);
    }

    public boolean containsValue(X obj) {
        return this.map.containsValue(obj);
    }

    @Nullable
    public X put(int x, int y, X obj) {
        Coords coords = new Coords(x, y);
        return this.map.put(coords, obj);
    }

    public boolean putIfAbsent(int x, int y, X obj) {
        Coords coords = new Coords(x, y);
        return this.map.putIfAbsent(coords, obj) != null;
    }

    @NotNull
    public Collection<X> values() {
        return new ArrayList<X>(this.map.values());
    }

    @NotNull
    public Collection<X> valuesByColumn(int x) {
        ArrayList<X> list = new ArrayList<X>();
        for (Coords coords : this.map.keySet()) {
            if (coords.x != x) continue;
            list.add(this.map.get(coords));
        }
        return list;
    }

    @NotNull
    public Collection<X> valuesByRow(int y) {
        ArrayList<X> list = new ArrayList<X>();
        for (Coords coords : this.map.keySet()) {
            if (coords.y != y) continue;
            list.add(this.map.get(coords));
        }
        return list;
    }

    public int getX(X x) {
        if (!this.map.containsValue(x)) {
            throw new IllegalArgumentException("Map does not contain this entry!");
        }
        for (Coords coords : this.map.keySet()) {
            if (!this.map.get(coords).equals(x)) continue;
            return coords.x;
        }
        throw new IllegalArgumentException("Map does not contain this entry!");
    }

    public int getY(X x) {
        if (!this.map.containsValue(x)) {
            throw new IllegalArgumentException("Map does not contain this entry!");
        }
        for (Coords coords : this.map.keySet()) {
            if (!this.map.get(coords).equals(x)) continue;
            return coords.y;
        }
        throw new IllegalArgumentException("Map does not contain this entry!");
    }

    public void clear() {
        this.map.clear();
    }

    static class Coords {
        int x;
        int y;

        public Coords(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public boolean equals(Object o) {
            Coords c = (Coords)o;
            return c.x == this.x && c.y == this.y;
        }

        public int hashCode() {
            return new Integer(this.x + "0" + this.y);
        }
    }
}

