/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.mask.api;

import com.moderocky.guardian.mask.annotation.API;
import com.moderocky.guardian.mask.annotation.Internal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;

@API
public class YamlConverter {
    @NotNull
    private final TreeMap<String, Object> dataMap = new TreeMap();

    @API
    public YamlConverter(YamlConfiguration configuration) {
        this.recursiveKeyLoop((ConfigurationSection)configuration, this.dataMap);
    }

    @API
    public YamlConverter(TreeMap<String, Object> inputMap) {
        this.dataMap.putAll(inputMap);
    }

    @API
    public void collect(YamlConfiguration configuration) {
        this.dataMap.clear();
        this.recursiveKeyLoop((ConfigurationSection)configuration, this.dataMap);
    }

    @API
    public void apply(YamlConfiguration configuration) {
        this.recursiveMapLoop(configuration, "", this.dataMap);
    }

    @API
    @NotNull
    public TreeMap<String, Object> getDataMap() {
        return this.dataMap;
    }

    @API
    public void clearDataMap() {
        this.dataMap.clear();
    }

    @API
    @NotNull
    public Set<String> getKeys(boolean deep) {
        if (deep) {
            return new HashSet<String>(this.recursiveKeySetLoop("", this.dataMap));
        }
        return this.dataMap.keySet();
    }

    @NotNull
    public Collection<Object> values(boolean deep) {
        if (deep) {
            return new ArrayList<Object>(this.recursiveValueLoop(this.dataMap));
        }
        return this.dataMap.values();
    }

    @Internal
    private List<Object> recursiveValueLoop(Map<String, Object> currentMap) {
        ArrayList<Object> objects = new ArrayList<Object>();
        for (String key : currentMap.keySet()) {
            Object value = currentMap.get(key);
            if (value instanceof Map) {
                Map map = (Map)value;
                objects.addAll(this.recursiveValueLoop(map));
                continue;
            }
            objects.add(value);
        }
        return objects;
    }

    @Internal
    private Set<String> recursiveKeySetLoop(String path, Map<String, Object> currentMap) {
        HashSet<String> strings = new HashSet<String>();
        for (String key : currentMap.keySet()) {
            String newPath = path.trim().equalsIgnoreCase("") ? key : path + "." + key;
            Object value = currentMap.get(key);
            if (value instanceof Map) {
                Map map = (Map)value;
                strings.addAll(this.recursiveKeySetLoop(newPath, map));
                continue;
            }
            strings.add(newPath);
        }
        return strings;
    }

    @Internal
    private void recursiveKeyLoop(ConfigurationSection section, Map<String, Object> currentMap) {
        for (String key : section.getKeys(false)) {
            if (section.isConfigurationSection(key)) {
                ConfigurationSection newSect = section.getConfigurationSection(key);
                if (newSect == null) continue;
                TreeMap<String, Object> map = new TreeMap<String, Object>();
                currentMap.put(key, map);
                this.recursiveKeyLoop(newSect, map);
                continue;
            }
            currentMap.put(key, section.get(key));
        }
    }

    @Internal
    private void recursiveMapLoop(YamlConfiguration configuration, String path, Map<String, Object> currentMap) {
        for (String key : currentMap.keySet()) {
            String newPath = path.trim().equalsIgnoreCase("") ? key : path + "." + key;
            Object value = currentMap.get(key);
            if (value instanceof Map) {
                Map map = (Map)value;
                this.recursiveMapLoop(configuration, newPath, map);
                continue;
            }
            configuration.set(newPath, value);
        }
    }
}

