/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.mask.api;

import com.moderocky.guardian.mask.api.MagicStringList;
import java.util.function.Function;
import java.util.regex.Pattern;

public final class StringReader {
    final char[] chars;
    transient int position;

    StringReader(MagicStringList list) {
        this.chars = list.toString().toCharArray();
    }

    public StringReader(String string) {
        this.chars = string.toCharArray();
    }

    public String readRest() {
        StringBuilder builder = new StringBuilder();
        while (this.canRead()) {
            builder.append(this.chars[this.position]);
            ++this.position;
        }
        return builder.toString();
    }

    public String read(int length) {
        int end = this.position + length;
        StringBuilder builder = new StringBuilder();
        while (this.position < end && this.position < this.chars.length) {
            builder.append(this.chars[this.position]);
            ++this.position;
        }
        return builder.toString();
    }

    public String readUntil(char c) {
        char test;
        StringBuilder builder = new StringBuilder();
        while (this.canRead() && c != (test = this.chars[this.position])) {
            builder.append(test);
            ++this.position;
        }
        return builder.toString();
    }

    public String readUntilMatches(Function<String, Boolean> function) {
        StringBuilder builder = new StringBuilder();
        while (this.canRead()) {
            char test = this.chars[this.position];
            builder.append(test);
            ++this.position;
            if (!function.apply(builder.toString()).booleanValue()) continue;
            break;
        }
        return builder.toString();
    }

    public String readUntilMatches(Pattern pattern) {
        StringBuilder builder = new StringBuilder();
        while (this.canRead()) {
            char test = this.chars[this.position];
            builder.append(test);
            if (pattern.matcher(builder.toString()).matches()) break;
            ++this.position;
        }
        return builder.toString();
    }

    public String readUntilMatchesAfter(Pattern pattern, char end) {
        StringBuilder builder = new StringBuilder();
        boolean canEnd = false;
        while (this.canRead()) {
            char test = this.chars[this.position];
            if (test == end) {
                canEnd = true;
            }
            if (canEnd && pattern.matcher(builder.toString()).matches()) break;
            builder.append(test);
            ++this.position;
        }
        return builder.toString();
    }

    public void skip() {
        if (this.canRead()) {
            ++this.position;
        }
    }

    public void skip(int i) {
        this.position += i;
    }

    public void rotateBack(int i) {
        this.position -= i;
    }

    public boolean canRead() {
        return this.position < this.chars.length;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int i) {
        this.position = i;
    }

    public int length() {
        return this.chars.length;
    }

    public char current() {
        if (this.canRead()) {
            return this.chars[this.position];
        }
        throw new RuntimeException("Limit exceeded!");
    }

    public char next() {
        if (this.position + 1 < this.chars.length) {
            return this.chars[this.position + 1];
        }
        throw new RuntimeException("Limit exceeded!");
    }

    public char rotate() {
        if (this.canRead()) {
            char c = this.chars[this.position];
            ++this.position;
            return c;
        }
        throw new RuntimeException("Limit exceeded!");
    }

    public void reset() {
        this.position = 0;
    }

    public String toString() {
        return new String(this.chars);
    }
}

