/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.mask.api;

import com.moderocky.guardian.mask.api.CaughtReflective;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Property {
    private Method getter;
    private Method setter;
    private Class<?> type;
    private Class<?> object;
    private String name;
    private boolean single;

    public CaughtReflective get(Object object) {
        if (object.getClass().isAssignableFrom(this.getType())) {
            try {
                Object ret = this.getGetter().invoke(object, new Object[0]);
                return new CaughtReflective<Object>(true, null, ret);
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                try {
                    Method method = object.getClass().getMethod(this.getGetter().getName(), new Class[0]);
                    Object ret = method.invoke(object, new Object[0]);
                    return new CaughtReflective<Object>(true, null, ret);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    return new CaughtReflective<Object>(false, e, null);
                }
            }
        }
        return new CaughtReflective<Object>(false, new ClassCastException("Passed object not an instance of " + this.getType().getName()), null);
    }

    public CaughtReflective set(Object object, Object value) {
        if (object.getClass().isAssignableFrom(this.getType())) {
            try {
                this.getSetter().invoke(object, value);
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                try {
                    Method method = object.getClass().getMethod(this.getSetter().getName(), new Class[0]);
                    method.invoke(object, value);
                    return new CaughtReflective<Property>(true, null, this);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    return new CaughtReflective<Object>(false, e, null);
                }
            }
            return new CaughtReflective<Property>(true, null, this);
        }
        return new CaughtReflective<Object>(false, new ClassCastException("Passed object not an instance of " + this.getType().getName()), null);
    }

    public boolean isSingle() {
        return this.single;
    }

    public Property setSingle(boolean single) {
        this.single = single;
        return this;
    }

    public boolean canGet() {
        return this.getter != null;
    }

    public boolean canSet() {
        return this.setter != null;
    }

    public Class<?> getObject() {
        return this.object;
    }

    public Property setObject(Class<?> object) {
        this.object = object;
        return this;
    }

    public Method getGetter() {
        return this.getter;
    }

    public Property setGetter(Method getter) {
        this.getter = getter;
        return this;
    }

    public Method getSetter() {
        return this.setter;
    }

    public Property setSetter(Method setter) {
        this.setter = setter;
        return this;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Property setType(Class<?> type) {
        this.type = type;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Property setName(String name) {
        this.name = name;
        return this;
    }
}

