/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.mask.api;

import com.moderocky.guardian.mask.api.MagicList;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Pattern;

public class MagicStringList
extends MagicList<String> {
    public MagicStringList() {
    }

    public MagicStringList(Collection<String> collection) {
        super(collection);
    }

    public MagicStringList(String ... strings) {
        super(Arrays.asList(strings));
    }

    public static MagicStringList from(Collection<?> collection) {
        MagicStringList list = new MagicStringList();
        for (Object o : collection) {
            list.add(o.toString());
        }
        return list;
    }

    public static MagicStringList from(Object ... objects) {
        MagicStringList list = new MagicStringList();
        for (Object o : objects) {
            list.add(o.toString());
        }
        return list;
    }

    public MagicStringList filter(Pattern pattern) {
        MagicStringList list = new MagicStringList();
        for (String string : this) {
            if (!pattern.matcher(string).matches()) continue;
            list.add(string);
        }
        return list;
    }

    public void removeMatching(Pattern pattern) {
        this.removeIf(string -> pattern.matcher((CharSequence)string).matches());
    }

    public void removeNotMatching(Pattern pattern) {
        this.removeIf(string -> !pattern.matcher((CharSequence)string).matches());
    }

    public boolean containsIgnoreCase(String string) {
        for (String s : this) {
            if (!s.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public boolean anyContains(String string) {
        for (String s : this) {
            if (!s.contains(string)) continue;
            return true;
        }
        return false;
    }

    public MagicStringList from(int start) {
        return this.from(start, this.size());
    }

    public MagicStringList from(int start, int end) {
        if (start < 0) {
            throw new IllegalArgumentException("Start index must be positive!");
        }
        if (end > this.size()) {
            throw new IllegalArgumentException("End index must not be greater than the list's size!");
        }
        MagicStringList list = new MagicStringList();
        for (int i = start; i < end; ++i) {
            list.add(this.get(i));
        }
        return list;
    }

    public String[] toArray() {
        return super.toArray(new String[0]);
    }

    @Override
    public String toString() {
        return String.join((CharSequence)" ", this);
    }
}

