/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.mask.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public class MagicMap<K, V>
extends LinkedHashMap<K, V> {
    public MagicMap() {
    }

    public MagicMap(Map<K, V> map) {
        super(map);
    }

    public MagicMap(List<K> keys, List<V> values) {
        for (int i = 0; i < Math.min(keys.size(), values.size()); ++i) {
            this.put(keys.get(i), values.get(i));
        }
    }

    public MagicMap(Collection<K> keys, Collection<V> values) {
        Object[] ks = keys.toArray();
        Object[] vs = values.toArray();
        for (int i = 0; i < Math.min(ks.length, vs.length); ++i) {
            this.put(ks[i], vs[i]);
        }
    }

    public boolean removeIf(Predicate<? super K> filter) {
        int a = this.size();
        for (Object key : new ArrayList(this.keySet())) {
            if (!filter.test(key)) continue;
            this.remove(key);
        }
        return this.size() != a;
    }

    public boolean removeEntryIf(Predicate<? super Map.Entry<? super K, ? super V>> filter) {
        int a = this.size();
        for (Map.Entry entry : new ArrayList(this.entrySet())) {
            if (!filter.test(entry)) continue;
            this.remove(entry);
        }
        return this.size() != a;
    }

    public Map.Entry<K, V> remove(int position) {
        if (position >= this.size()) {
            throw new IllegalArgumentException("Index is out of bounds!");
        }
        int i = 0;
        for (final Object k : this.keySet()) {
            if (i == position) {
                return new Map.Entry<K, V>(){

                    @Override
                    public K getKey() {
                        return k;
                    }

                    @Override
                    public V getValue() {
                        return MagicMap.this.remove(k);
                    }

                    @Override
                    public V setValue(V value) {
                        return null;
                    }
                };
            }
            ++i;
        }
        throw new IllegalArgumentException("Index is out of bounds!");
    }

    public Map.Entry<K, V> getFirst() {
        return this.get(0);
    }

    public Map.Entry<K, V> getLast() {
        return this.get(this.size() - 1);
    }

    public Map.Entry<K, V> get(int position) {
        if (position >= this.size() || position < 0) {
            throw new IllegalArgumentException("Index is out of bounds!");
        }
        int i = 0;
        for (final Object k : this.keySet()) {
            if (i == position) {
                return new Map.Entry<K, V>(){

                    @Override
                    public K getKey() {
                        return k;
                    }

                    @Override
                    public V getValue() {
                        return MagicMap.this.get(k);
                    }

                    @Override
                    public V setValue(V value) {
                        return MagicMap.this.replace(k, value);
                    }
                };
            }
            ++i;
        }
        throw new IllegalArgumentException("Index is out of bounds!");
    }
}

